/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import org.apache.maven.artifact.ant.shaded.StringUtils;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;

public class JdkPrefixProfileActivator
extends DetectedProfileActivator {
    private static final String JDK_VERSION = System.getProperty("java.version");

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        String jdk = activation.getJdk();
        boolean reverse = false;
        if (jdk.startsWith("!")) {
            reverse = true;
            jdk = jdk.substring(1);
        }
        boolean result = JDK_VERSION.startsWith(jdk);
        if (reverse) {
            return !result;
        }
        return result;
    }

    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && StringUtils.isNotEmpty(profile.getActivation().getJdk());
    }
}

