/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;

public class CheckLinks
extends MatchingTask {
    private File basedir;
    private boolean checkexternal = true;
    private List mappers = new LinkedList();
    private static Pattern hrefOrAnchor = Pattern.compile("<(a|img)(\\s+shape=\"rect\")?\\s+(href|name|src)=\"([^\"#]*)(#[^\"]+)?\"(\\s+shape=\"rect\")?>", 2);
    private static Pattern lineBreak = Pattern.compile("^", 8);

    public void setCheckexternal(boolean ce) {
        this.checkexternal = ce;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public Mapper createMapper() {
        Mapper m = new Mapper(this.getProject());
        this.mappers.add(m);
        return m;
    }

    public void execute() throws BuildException {
        if (this.basedir == null) {
            throw new BuildException("Must specify the basedir attribute");
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.basedir);
        scanner.scan();
        String message = "Scanning for broken links in " + this.basedir + " ...";
        if (!this.checkexternal) {
            message = message + " (external URLs will be skipped)";
        }
        this.log(message);
        String[] files = scanner.getIncludedFiles();
        HashSet okurls = new HashSet(1000);
        HashSet badurls = new HashSet(100);
        HashSet cleanurls = new HashSet(100);
        for (int i = 0; i < files.length; ++i) {
            File file = new File(this.basedir, files[i]);
            URI fileurl = file.toURI();
            this.log("Scanning " + file, 3);
            try {
                CheckLinks.scan((Task)this, this.getLocation().toString(), "", fileurl, okurls, badurls, cleanurls, this.checkexternal, 1, this.mappers);
                continue;
            }
            catch (IOException ioe) {
                throw new BuildException("Could not scan " + file + ": " + ioe, (Throwable)ioe, this.location);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scan(Task task, String referrer, String referrerLocation, URI u, Set okurls, Set badurls, Set cleanurls, boolean checkexternal, int recurse, List mappers) throws IOException {
        String content;
        String mimeType;
        URI base;
        if (okurls.contains(u) && recurse == 0) {
            return;
        }
        String b = u.toString();
        int i = b.lastIndexOf(35);
        if (i != -1) {
            b = b.substring(0, i);
        }
        try {
            base = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), u.getQuery(), null);
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        String frag = u.getFragment();
        String basepath = base.toString();
        if ("file".equals(base.getScheme())) {
            try {
                basepath = new File(base).getAbsolutePath();
            }
            catch (IllegalArgumentException e) {
                task.log(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": malformed URL: " + base + " (" + e.getLocalizedMessage() + ")", 1);
            }
        }
        if (badurls.contains(u) || badurls.contains(base)) {
            task.log(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": broken link (already reported): " + u, 1);
            return;
        }
        if (!checkexternal && !"file".equals(u.getScheme())) {
            task.log("Skipping external link: " + base, 3);
            cleanurls.add(base);
            okurls.add(base);
            okurls.add(u);
            return;
        }
        task.log("Checking " + u + " (recursion level " + recurse + ")", 3);
        try {
            URLConnection conn = base.toURL().openConnection();
            conn.connect();
            mimeType = conn.getContentType();
            InputStream is = conn.getInputStream();
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            try {
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                content = baos.toString(enc);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            task.log(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": broken link: " + base, 1);
            task.log("Error: " + ioe, 3);
            badurls.add(base);
            badurls.add(u);
            return;
        }
        okurls.add(base);
        HashMap<URI, String> others = null;
        if (recurse > 0 && cleanurls.add(base)) {
            others = new HashMap<URI, String>(100);
        }
        if (recurse == 0 && frag == null) {
            return;
        }
        if ("text/html".equals(mimeType)) {
            task.log("Parsing " + base, 3);
            Matcher m = hrefOrAnchor.matcher(content);
            HashSet<String> names = new HashSet<String>(100);
            while (m.find()) {
                String fixedUri;
                String type = m.group(3);
                if (type.equalsIgnoreCase("name")) {
                    String name = CheckLinks.unescape(m.group(4));
                    if (names.add(name)) {
                        try {
                            okurls.add(new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), base.getPath(), base.getQuery(), name));
                        }
                        catch (URISyntaxException e) {
                            task.log(CheckLinks.normalize(basepath, mappers) + CheckLinks.findLocation(content, m.start(4)) + ": bad anchor name: " + e.getMessage(), 1);
                        }
                        continue;
                    }
                    if (recurse != 1) continue;
                    task.log(CheckLinks.normalize(basepath, mappers) + CheckLinks.findLocation(content, m.start(4)) + ": duplicate anchor name: " + name, 1);
                    continue;
                }
                if (others == null) continue;
                String otherbase = CheckLinks.unescape(m.group(4));
                String otheranchor = CheckLinks.unescape(m.group(5));
                String uri = otheranchor == null ? otherbase : otherbase + otheranchor;
                String location = CheckLinks.findLocation(content, m.start(4));
                if (uri.indexOf(32) != -1) {
                    fixedUri = uri.replaceAll(" ", "%20");
                    task.log(CheckLinks.normalize(basepath, mappers) + location + ": spaces in URIs should be encoded as \"%20\": " + uri, 1);
                } else {
                    fixedUri = uri;
                }
                try {
                    URI o;
                    URI relUri = new URI(fixedUri);
                    if (relUri.isOpaque() || others.containsKey(o = base.resolve(relUri))) continue;
                    others.put(o, location);
                }
                catch (URISyntaxException e) {
                    task.log(CheckLinks.normalize(basepath, mappers) + location + ": bad relative URI: " + e.getMessage(), 1);
                }
            }
        } else {
            task.log("Not checking contents of " + base, 3);
        }
        if (!okurls.contains(u)) {
            task.log(CheckLinks.normalize(referrer, mappers) + referrerLocation + ": broken link: " + u, 1);
        }
        if (others != null) {
            Iterator it = others.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                URI other = (URI)entry.getKey();
                String location = (String)entry.getValue();
                CheckLinks.scan(task, basepath, location, other, okurls, badurls, cleanurls, checkexternal, recurse == 1 ? 0 : 2, mappers);
            }
        }
    }

    private static String normalize(String path, List mappers) throws IOException {
        try {
            Iterator it = mappers.iterator();
            while (it.hasNext()) {
                Mapper m = (Mapper)it.next();
                String[] nue = m.getImplementation().mapFileName(path);
                if (nue == null) continue;
                for (int i = 0; i < nue.length; ++i) {
                    if (!new File(nue[i]).isFile()) continue;
                    return nue[i];
                }
            }
            return path;
        }
        catch (BuildException e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String unescape(String text) {
        int search;
        if (text == null) {
            return null;
        }
        int pos = 0;
        while ((search = text.indexOf(38, pos)) != -1) {
            void var5_5;
            String repl;
            int semi = text.indexOf(59, search + 1);
            if (semi == -1) {
                return text;
            }
            String entity = text.substring(search + 1, semi);
            if (entity.equals("amp")) {
                repl = "&";
            } else if (entity.equals("quot")) {
                repl = "\"";
            } else if (entity.equals("lt")) {
                repl = "<";
            } else if (entity.equals("gt")) {
                repl = ">";
            } else if (entity.equals("apos")) {
                repl = "'";
            } else {
                pos = semi + 1;
                continue;
            }
            text = text.substring(0, search) + (String)var5_5 + text.substring(semi + 1);
            pos = search + var5_5.length();
        }
        return text;
    }

    private static String findLocation(CharSequence content, int pos) {
        Matcher lbm = lineBreak.matcher(content);
        int line = 0;
        int col = 1;
        while (lbm.find() && lbm.start() <= pos) {
            ++line;
            col = pos - lbm.start() + 1;
        }
        return ":" + line + ":" + col;
    }
}

