/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.FileExtFilter;

public class CopyFilesOfType
extends Task {
    protected String fromTopDirs = null;
    protected String fromDirs = null;
    protected String toDir = null;
    protected String fileExt = null;
    protected boolean failOnBadParams = true;
    protected LinkedList fromDirList = new LinkedList();
    protected LinkedList fromTopDirList = new LinkedList();
    protected LinkedList fileExtList = new LinkedList();
    protected String tokenSep = ",";
    protected FileExtFilter fileFilter = new FileExtFilter();
    protected int totalNumCopied = 0;

    public void setFromDirs(String s) {
        this.fromDirs = s;
    }

    public void setToDir(String s) {
        this.toDir = s;
    }

    public void setFileExt(String s) {
        this.fileExt = s;
    }

    public void setFromTopDirs(String s) {
        this.fromTopDirs = s;
    }

    public void setFailOnBadParams(boolean fail) {
        this.failOnBadParams = fail;
    }

    public void execute() throws BuildException {
        int i = 0;
        int j = 0;
        Object[] dirs = null;
        Object[] topDirs = null;
        String dir = null;
        String topDir = null;
        File fromDir = null;
        if (!this.setupAndCheck()) {
            return;
        }
        dirs = this.fromDirList.toArray();
        if (this.fromTopDirList.size() > 0) {
            topDirs = this.fromTopDirList.toArray();
        }
        try {
            for (i = 0; i < dirs.length; ++i) {
                dir = (String)dirs[i];
                if (topDirs == null) {
                    this.copyFiles(new File(dir));
                    continue;
                }
                for (j = 0; j < topDirs.length; ++j) {
                    topDir = (String)topDirs[j];
                    fromDir = new File(topDir, dir);
                    this.copyFiles(fromDir);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage());
        }
        this.log("Copied " + this.totalNumCopied + " files to " + this.toDir);
    }

    protected void copyFiles(File fromDir) throws IOException {
        File[] files = null;
        File file = null;
        int i = 0;
        int numCopied = 0;
        if (fromDir.exists()) {
            files = fromDir.listFiles(this.fileFilter);
            if (files != null) {
                for (i = 0; i < files.length; ++i) {
                    file = files[i];
                    if (!file.isFile()) continue;
                    ++numCopied;
                    this.project.copyFile(file, new File(this.toDir, file.getName()), false, true);
                }
            }
            if (numCopied == 0) {
                this.log("No files in " + fromDir.getAbsolutePath() + " to copy.", 3);
            }
        }
        this.totalNumCopied += numCopied;
    }

    protected boolean setupAndCheck() throws BuildException {
        Object[] extensions = null;
        String ext = null;
        String msg = null;
        int i = 0;
        boolean all_ok = true;
        this.fillList(this.fromDirList, this.fromDirs);
        this.fillList(this.fromTopDirList, this.fromTopDirs);
        this.fillList(this.fileExtList, this.fileExt);
        if (this.fromDirList.size() == 0) {
            all_ok = false;
            msg = "fromDirs is not specified.";
            if (this.failOnBadParams) {
                throw new BuildException(msg);
            }
            this.log("WARNING: " + msg);
        }
        if (this.fileExtList.size() == 0) {
            all_ok = false;
            msg = "fileExt is not specified.";
            if (this.failOnBadParams) {
                throw new BuildException(msg);
            }
            this.log("WARNING: " + msg);
        }
        if (this.toDir == null || this.toDir.equals("")) {
            all_ok = false;
            msg = "toDir is not specified.";
            if (this.failOnBadParams) {
                throw new BuildException(msg);
            }
            this.log("WARNING: " + msg);
        }
        extensions = this.fileExtList.toArray();
        for (i = 0; i < extensions.length; ++i) {
            ext = (String)extensions[i];
            this.fileFilter.addExt(ext);
        }
        return all_ok;
    }

    protected void fillList(LinkedList list, String names) {
        StringTokenizer st = null;
        st = new StringTokenizer(names, this.tokenSep);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            s = s.trim();
            list.add(s);
        }
    }
}

