/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.CvsFileSet;

public class FindBadConstructions
extends Task {
    private static final Pattern lineBreak = Pattern.compile("^", 8);
    private List filesets = new LinkedList();
    private List bad = new LinkedList();

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void addCvsFileset(CvsFileSet fs) {
        this.filesets.add(fs);
    }

    public Construction createConstruction() {
        Construction c = new Construction();
        this.bad.add(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.filesets.isEmpty()) {
            throw new BuildException("Must give at least one fileset", this.location);
        }
        if (this.bad.isEmpty()) {
            throw new BuildException("Must give at least one construction", this.location);
        }
        Iterator it = this.filesets.iterator();
        while (it.hasNext()) {
            FileSet fs = (FileSet)it.next();
            DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
            File dir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            this.log("Scanning " + files.length + " files in " + dir);
            for (int i = 0; i < files.length; ++i) {
                File f = new File(dir, files[i]);
                try {
                    Iterator it2 = this.bad.iterator();
                    while (it2.hasNext()) {
                        Construction c = (Construction)it2.next();
                        if (c.regexp == null) {
                            throw new BuildException("Must specify regexp on a construction", this.location);
                        }
                        FileInputStream fis = new FileInputStream(f);
                        FileChannel fc = fis.getChannel();
                        try {
                            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
                            Charset cs = Charset.forName("UTF-8");
                            CharBuffer content = cs.decode(bb);
                            Matcher m = c.regexp.matcher(content);
                            while (m.find()) {
                                StringBuffer message = new StringBuffer(1000);
                                message.append(f.getAbsolutePath());
                                message.append(':');
                                Matcher lbm = lineBreak.matcher(content);
                                int line = 0;
                                int col = 1;
                                while (lbm.find() && lbm.start() <= m.start()) {
                                    ++line;
                                    col = m.start() - lbm.start() + 1;
                                }
                                message.append(line);
                                message.append(":");
                                message.append(col);
                                message.append(": ");
                                if (c.message != null) {
                                    message.append(c.message);
                                }
                                if (c.show != -1) {
                                    if (c.message != null) {
                                        message.append(": ");
                                    }
                                    message.append(m.group(c.show));
                                }
                                if (c.show == -1 && c.message == null) {
                                    message.append("bad construction found");
                                }
                                this.log(message.toString(), 1);
                            }
                        }
                        finally {
                            fc.close();
                            fis.close();
                        }
                    }
                    continue;
                }
                catch (IOException ioe) {
                    throw new BuildException("Error reading " + f, (Throwable)ioe, this.location);
                }
            }
        }
    }

    public class Construction {
        Pattern regexp;
        String message = null;
        int show = -1;

        public void setRegexp(String r) throws BuildException {
            try {
                this.regexp = Pattern.compile(r, 8);
            }
            catch (PatternSyntaxException rese) {
                throw new BuildException((Throwable)rese, FindBadConstructions.this.location);
            }
        }

        public void setMessage(String m) {
            this.message = m;
        }

        public void setShowMatch(int s) {
            this.show = s;
        }
    }
}

