/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class InputCharSequence
implements CharSequence {
    private final Reader reader;
    private final InputStream is;
    private final StringBuffer buf;
    private boolean closed;

    private InputCharSequence(Reader reader, InputStream is) {
        this.reader = reader;
        this.is = is;
        this.buf = new StringBuffer(512);
        this.closed = false;
    }

    public InputCharSequence(Reader reader) {
        this(reader, null);
    }

    public InputCharSequence(InputStream is) {
        this(null, is);
    }

    public char charAt(int index) {
        try {
            this.ensure(index);
            return this.buf.charAt(index);
        }
        catch (IOException e) {
            throw new StringIndexOutOfBoundsException(e.getMessage());
        }
    }

    public int length() {
        this.readAll();
        return this.buf.length();
    }

    public CharSequence subSequence(int start, int end) {
        try {
            this.ensure(end);
            return this.buf.subSequence(start, end);
        }
        catch (IOException e) {
            throw new StringIndexOutOfBoundsException(e.getMessage());
        }
    }

    public String substring(int start, int end) {
        return ((Object)this.subSequence(start, end)).toString();
    }

    public String substring(int start) {
        return this.toString().substring(start);
    }

    public String toString() {
        this.readAll();
        return this.buf.toString();
    }

    private void ensure(int index) throws IOException {
        if (this.closed || index < this.buf.length()) {
            return;
        }
        this.read(index + 1 - this.buf.length());
    }

    private void readAll() {
        try {
            while (!this.closed) {
                this.read(1024);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int read(int n) throws IOException {
        if (this.reader != null) {
            char[] carray = new char[n];
            int total = 0;
            int nr = 0;
            do {
                if ((nr = this.reader.read(carray)) < 0) {
                    this.closed = true;
                    break;
                }
                this.buf.append(carray, 0, nr);
            } while ((total += nr) < n);
            return total;
        }
        int nr = n;
        while (--nr >= 0) {
            int c = this.is.read();
            if (c < 0) {
                this.closed = true;
                break;
            }
            this.buf.append((char)c);
        }
        return n - nr;
    }
}

