/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class Issue
implements Comparable {
    static final String ISSUE_TYPE = "issue_type";
    static final String SHORT_DESC = "short_desc";
    static final String LONG_DESC = "long_desc";
    static final String COMMENT = "comment";
    static final String ISSUE_ID = "issue_id";
    static final String ISSUE_STATUS = "issue_status";
    static final String RESOLUTION = "resolution";
    static final String COMPONENT = "component";
    static final String REPORTER = "reporter";
    static final String VERSION = "version";
    static final String SUBCOMPONENT = "subcomponent";
    static final String REP_PLATFORM = "rep_platform";
    static final String OP_SYS = "op_sys";
    static final String PRIORITY = "priority";
    static final String ASSIGNED_TO = "assigned_to";
    static final String CC = "cc";
    static final String DEPENDS_ON = "dependson";
    static final String BLOCKS = "blocks";
    static final String CREATED = "creation_ts";
    static final String VOTES = "votes";
    static final String KEYWORDS = "keywords";
    static final String STATUS_WHITEBOARD = "status_whiteboard";
    static final String TARGET_MILESTONE = "target_milestone";
    static final String LONG_DESC_LIST = "long_desc_list";
    private HashMap attributes = new HashMap(49);

    public int getId() {
        Object id = this.getAttribute(ISSUE_ID);
        try {
            return Integer.parseInt((String)id);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public String getAssignedTo() {
        return this.string(ASSIGNED_TO);
    }

    public String getReportedBy() {
        return this.string(REPORTER);
    }

    public String[] getObservedBy() {
        List l = (List)this.getAttribute(CC);
        if (l != null) {
            return l.toArray(new String[0]);
        }
        return new String[0];
    }

    public String getStatus() {
        return this.string(ISSUE_STATUS);
    }

    public String getResolution() {
        return this.string(RESOLUTION);
    }

    public String getType() {
        return this.string(ISSUE_TYPE);
    }

    public int getPriority() {
        String s = this.string(PRIORITY);
        if (s.length() == 2 && s.charAt(0) == 'P') {
            return s.charAt(1) - 48;
        }
        return -1;
    }

    public Date getCreated() {
        Date d = (Date)this.getAttribute(CREATED);
        return d == null ? new Date(0L) : d;
    }

    public String getSummary() {
        return this.string(SHORT_DESC);
    }

    public Description[] getDescriptions() {
        Object obj = this.getAttribute(LONG_DESC_LIST);
        if (obj == null) {
            return new Description[0];
        }
        return ((List)obj).toArray(new Description[0]);
    }

    public int[] getDependsOn() {
        return this.ints(DEPENDS_ON);
    }

    public int[] getBlocks() {
        return this.ints(BLOCKS);
    }

    public String getTargetMilestone() {
        return this.string(TARGET_MILESTONE);
    }

    public String getComponent() {
        return this.string(COMPONENT);
    }

    public String getSubcomponent() {
        return this.string(SUBCOMPONENT);
    }

    public String getDuration() {
        String val = this.getWhiteboardAttribute("duration");
        return val == null ? "" : val;
    }

    public final String getWhiteboardAttribute(String attribute) {
        String ret = null;
        String swb = this.string(STATUS_WHITEBOARD);
        StringTokenizer st = new StringTokenizer(swb);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.startsWith(attribute + '=')) continue;
            ret = token.substring(token.indexOf(61) + 1);
            break;
        }
        return ret;
    }

    public int getVotes() {
        try {
            String s = this.string(VOTES);
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public String getKeywords() {
        try {
            return this.string(KEYWORDS);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public boolean containsKeyword(String keyword) {
        StringTokenizer tokenizer = new StringTokenizer(this.getKeywords());
        while (tokenizer.hasMoreTokens()) {
            String current = tokenizer.nextToken();
            if (!current.equals(keyword)) continue;
            return true;
        }
        return false;
    }

    private String string(String name) {
        Object o = this.getAttribute(name);
        return o instanceof String ? (String)o : "";
    }

    private int[] ints(String name) {
        List l = (List)this.getAttribute(name);
        if (l == null) {
            return new int[0];
        }
        int[] arr = new int[l.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Integer.parseInt((String)l.get(i));
        }
        return arr;
    }

    Object getAttribute(String name) {
        if (name.equals(LONG_DESC)) {
            return this.formatLongDescriptions();
        }
        return this.attributes.get(name);
    }

    void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    private Map attributes() {
        return this.attributes;
    }

    public String toString() {
        if (this.attributes == null) {
            return "Empty BugBase";
        }
        Iterator it = this.attributes.entrySet().iterator();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + " containing these name/value attribute pairs:\n");
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            buffer.append("NAME  : " + entry.getKey() + "\n");
            buffer.append("VALUE : " + entry.getValue() + "\n");
        }
        return buffer.toString();
    }

    public int compareTo(Object o) {
        Issue i = (Issue)o;
        return this.getId() - i.getId();
    }

    private String formatLongDescriptions() {
        if (this.attributes.get(LONG_DESC) == null) {
            StringBuffer buffer = new StringBuffer("");
            Object obj = this.getAttribute(LONG_DESC_LIST);
            if (obj == null) {
                return null;
            }
            List descriptions = (List)obj;
            Iterator it = descriptions.iterator();
            while (it.hasNext()) {
                Description ld = (Description)it.next();
                buffer.append(ld.toString());
            }
            this.attributes.put(LONG_DESC, buffer.toString());
        }
        return this.attributes.get(LONG_DESC).toString();
    }

    public static final class Description {
        static final String WHO = "who";
        static final String ISSUE_WHEN = "issue_when";
        static final String BODY = "body";
        static final String THETEXT = "thetext";
        private String who;
        private Date when;
        private String body;

        public String getWho() {
            return this.who;
        }

        void setWho(String who) {
            this.who = who;
        }

        public Date getWhen() {
            return this.when;
        }

        void setIssueWhen(Date when) {
            this.when = when;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getWho());
            buffer.append(", ");
            buffer.append(this.getWhen());
            buffer.append(" : \n");
            buffer.append(this.getBody());
            buffer.append("\n\n");
            return buffer.toString();
        }

        void setBody(String body) {
            this.body = body;
        }

        void setAtribute(String name, String value) {
            if (name.equalsIgnoreCase(WHO)) {
                this.setWho(value);
            } else if (name.equalsIgnoreCase(BODY) || name.equalsIgnoreCase(THETEXT)) {
                this.setBody(value);
            }
        }

        private String getAttribute(String name) {
            if (name.equalsIgnoreCase(WHO)) {
                return this.who;
            }
            if (name.equalsIgnoreCase(BODY) || name.equalsIgnoreCase(THETEXT)) {
                return this.body;
            }
            return null;
        }
    }
}

