/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.netbeans.nbbuild.Issue;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class IssuezillaXMLHandler
extends HandlerBase {
    private static final String DTD_VERSION = "1.7";
    private static final String DTD_VERSION_NAME = "dtd_version";
    private static final String ISSUE_STATUS = "issue_status";
    private static final String RESOLUTION = "resolution";
    private static final String PRIORITY = "priority";
    private static final String ISSUE = "issue";
    private static final String ISSUEZILLA = "issuezilla";
    private static final String LONG_DESC = "long_desc";
    private static final String WHO = "who";
    private static final String ISSUE_WHEN = "issue_when";
    private static final String THETEXT = "thetext";
    private static final HashSet tagsInIssue = new HashSet();
    private static final List tagsInLongDesc;
    private List bugs;
    private Map bug;
    private Vector openedTags;
    private StringBuffer buffer;
    private StringBuffer longDescBuffer;
    private List longDescriptionList;
    private Issue.Description longDesc;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dateFormat2;

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.bugs = new ArrayList();
        this.openedTags = new Vector();
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.openedTags.addElement(name);
        if (name.equals(ISSUEZILLA)) {
            this.checkDTDVersion(atts);
        } else if (name.equals(ISSUE)) {
            this.bug = new HashMap();
            this.bugs.add(this.bug);
            this.longDescriptionList = new ArrayList();
            this.bug.put("long_desc_list", this.longDescriptionList);
            this.bug.put("cc", new ArrayList());
            this.bug.put("dependson", new ArrayList());
            this.bug.put("blocks", new ArrayList());
            this.bug.put("creation_ts", new Date(0L));
            this.dealIssueAttributes(atts);
        } else if (tagsInIssue.contains(name)) {
            this.buffer = new StringBuffer();
        } else if (tagsInLongDesc.contains(name)) {
            this.longDescBuffer = new StringBuffer();
        } else if (name.equals(LONG_DESC)) {
            this.longDesc = new Issue.Description();
            this.longDescriptionList.add(this.longDesc);
        }
    }

    public void endElement(String name) throws SAXException {
        if (!this.currentTag().equals(name)) {
            throw new SAXException("An error while parsing the XML file near the closing " + name + " tag");
        }
        this.openedTags.remove(this.openedTags.size() - 1);
        if (!name.equals(ISSUEZILLA)) {
            if (tagsInIssue.contains(name)) {
                Object prev = this.bug.get(name);
                if (prev instanceof List) {
                    ((List)prev).add(this.buffer.toString());
                } else if (prev instanceof Date) {
                    this.bug.put(name, this.toDate(this.buffer.toString()));
                } else {
                    this.bug.put(name, this.buffer.toString());
                }
                this.buffer = null;
            } else if (!name.equalsIgnoreCase(LONG_DESC) && tagsInLongDesc.contains(name)) {
                String s = this.longDescBuffer.toString();
                if (name.equals(ISSUE_WHEN)) {
                    this.longDesc.setIssueWhen(this.toDate(s));
                } else {
                    this.longDesc.setAtribute(name, s);
                }
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (!s.equals("")) {
            if (tagsInLongDesc.contains(this.currentTag())) {
                this.longDescBuffer.append(s);
            } else if (this.buffer != null) {
                this.buffer.append(s);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    private String currentTag() {
        if (this.openedTags.size() == 0) {
            return null;
        }
        return (String)this.openedTags.lastElement();
    }

    public List getBugList() {
        return this.bugs;
    }

    private void dealIssueAttributes(AttributeList atts) throws SAXException {
        String priority = atts.getValue(PRIORITY);
        String issue_status = atts.getValue(ISSUE_STATUS);
        String resolution = atts.getValue(RESOLUTION);
        if (priority == null) {
            priority = "P0";
        }
        this.bug.put(PRIORITY, priority);
        this.bug.put(ISSUE_STATUS, issue_status);
        if (resolution != null) {
            this.bug.put(RESOLUTION, resolution);
        }
    }

    private void checkDTDVersion(AttributeList atts) throws SAXException {
        String dtdVersion = atts.getValue(DTD_VERSION_NAME);
        if (dtdVersion == null || !dtdVersion.equals(DTD_VERSION)) {
            // empty if block
        }
    }

    public Date toDate(String date) {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        }
        if (this.dateFormat2 == null) {
            this.dateFormat2 = new SimpleDateFormat("yyyy-mm-dd hh:mm");
        }
        try {
            return this.dateFormat.parse(date);
        }
        catch (ParseException ex1) {
            try {
                return this.dateFormat2.parse(date);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    static {
        tagsInIssue.add("issue_id");
        tagsInIssue.add("component");
        tagsInIssue.add("version");
        tagsInIssue.add("rep_platform");
        tagsInIssue.add("assigned_to");
        tagsInIssue.add("delta_ts");
        tagsInIssue.add("subcomponent");
        tagsInIssue.add("reporter");
        tagsInIssue.add("target_milestone");
        tagsInIssue.add("issue_type");
        tagsInIssue.add("creation_ts");
        tagsInIssue.add("qa_contact");
        tagsInIssue.add("status_whiteboard");
        tagsInIssue.add("op_sys");
        tagsInIssue.add("short_desc");
        tagsInIssue.add("blocks");
        tagsInIssue.add("cc");
        tagsInIssue.add("dependson");
        tagsInIssue.add("votes");
        tagsInIssue.add("keywords");
        tagsInLongDesc = new ArrayList();
        tagsInLongDesc.add(WHO);
        tagsInLongDesc.add(ISSUE_WHEN);
        tagsInLongDesc.add(THETEXT);
    }
}

