/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class LocalizedJar
extends MatchingTask {
    private List localeKits = new LinkedList();
    private List locales = new LinkedList();
    private List brandings = new LinkedList();
    private File jarFile;
    private File baseDir;
    private boolean doCompress = false;
    private boolean doIndex = false;
    private static long emptyCrc = new CRC32().getValue();
    private List filesets = new LinkedList();
    private File manifest;
    private boolean checkPathLocale = true;
    private boolean warnMissingDir = false;
    private boolean warnMissingDirSet = false;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$MatchingTask;

    public void addLocalekit(FileSet fs) {
        this.localeKits.add(fs);
    }

    public LocaleOrB createLocale() {
        LocaleOrB l = new LocaleOrB();
        this.locales.add(l);
        return l;
    }

    public LocaleOrB createBranding() {
        LocaleOrB l = new LocaleOrB();
        this.brandings.add(l);
        return l;
    }

    public void setJarfile(File jarFile) {
        if (!jarFile.getName().endsWith(".jar")) {
            throw new BuildException("jarfile attribute must be a file with *.jar extension");
        }
        if (jarFile.getParentFile() == null) {
            throw new BuildException("jarfile attribute must have a containing directory");
        }
        this.jarFile = jarFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(String compress) {
        this.doCompress = Project.toBoolean((String)compress);
    }

    public void setIndex(String index) {
        this.doIndex = Project.toBoolean((String)index);
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public void setCheckPathLocale(boolean doit) {
        this.checkPathLocale = doit;
    }

    public void setWarnMissingDir(boolean b) {
        this.warnMissingDir = b;
        this.warnMissingDirSet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Iterator<Object> it2;
        int i;
        String[] files;
        File thisBaseDir;
        FileScanner scanner;
        if (this.baseDir == null && this.filesets.size() == 0) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.jarFile == null) {
            throw new BuildException("You must specify the JAR file to create!");
        }
        if (this.manifest != null && !this.manifest.isFile()) {
            throw new BuildException("The specified manifest does not actually exist.");
        }
        if (this.shouldWarnMissingDir() && this.warnIfMissingDir()) {
            return;
        }
        this.addGlobalLocaleAndBranding();
        HashMap<String, File> allFiles = new HashMap<String, File>();
        ArrayList<DirectoryScanner> scanners = new ArrayList<DirectoryScanner>(this.filesets.size() + 1);
        if (this.baseDir != null) {
            scanners.add(this.getDirectoryScanner(this.baseDir));
        }
        Iterator it = this.filesets.iterator();
        while (it.hasNext()) {
            scanners.add(((FileSet)it.next()).getDirectoryScanner(this.project));
        }
        it = scanners.iterator();
        while (it.hasNext()) {
            scanner = (FileScanner)it.next();
            thisBaseDir = scanner.getBasedir();
            files = scanner.getIncludedFiles();
            for (i = 0; i < files.length; ++i) {
                String name = files[i].replace(File.separatorChar, '/');
                if (name.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    this.log("Warning: ignoring META-INF/MANIFEST.MF found among scanned files", 1);
                    continue;
                }
                allFiles.put(name, new File(thisBaseDir, files[i]));
            }
        }
        HashSet<File> localeKitFiles = new HashSet<File>();
        it = this.localeKits.iterator();
        while (it.hasNext()) {
            scanner = ((FileSet)it.next()).getDirectoryScanner(this.project);
            thisBaseDir = scanner.getBasedir();
            files = scanner.getIncludedFiles();
            for (i = 0; i < files.length; ++i) {
                localeKitFiles.add(new File(thisBaseDir, files[i]));
            }
        }
        LinkedList<String> locales2 = new LinkedList<String>();
        LinkedList<String> brandings2 = new LinkedList<String>();
        Iterator it3 = this.locales.iterator();
        while (it3.hasNext()) {
            locales2.add(((LocaleOrB)it3.next()).n);
        }
        it3 = this.brandings.iterator();
        while (it3.hasNext()) {
            brandings2.add(((LocaleOrB)it3.next()).n);
        }
        class InverseLengthComparator
        implements Comparator {
            InverseLengthComparator() {
            }

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s2.length() - s1.length();
            }
        }
        InverseLengthComparator c = new InverseLengthComparator();
        Collections.sort(locales2, c);
        Collections.sort(brandings2, c);
        HashSet<File> jars = new HashSet<File>();
        HashMap<File, String> localeMarks = new HashMap<File, String>();
        HashMap<File, String> brandingMarks = new HashMap<File, String>();
        HashMap<File, TreeMap<String, File>> router = new HashMap<File, TreeMap<String, File>>();
        Iterator it4 = allFiles.entrySet().iterator();
        while (it4.hasNext()) {
            File thisjar;
            String localeDir;
            Map.Entry entry = it4.next();
            String path = (String)entry.getKey();
            File file = (File)entry.getValue();
            String testpath = path;
            int idx = testpath.lastIndexOf(47);
            if (idx != -1) {
                testpath = testpath.substring(idx + 1);
            }
            if ((idx = testpath.lastIndexOf(46)) != -1) {
                testpath = testpath.substring(0, idx);
            }
            String thisLocale = null;
            it2 = locales2.iterator();
            while (it2.hasNext()) {
                String tryLocale = (String)it2.next();
                if (!testpath.endsWith("_" + tryLocale)) continue;
                thisLocale = tryLocale;
                testpath = testpath.substring(0, testpath.length() - 1 - tryLocale.length());
                break;
            }
            String thisBranding = null;
            it2 = brandings2.iterator();
            while (it2.hasNext()) {
                String tryBranding = (String)it2.next();
                if (!testpath.endsWith("_" + tryBranding)) continue;
                thisBranding = tryBranding;
                break;
            }
            if ((localeDir = this.checkInLocaleDir(file, locales2)) != null) {
                thisLocale = localeDir;
            }
            if (thisLocale != null || thisBranding != null || localeKitFiles.contains(file)) {
                String name = this.jarFile.getName();
                name = name.substring(0, name.length() - 4);
                if (thisBranding != null) {
                    name = name + '_' + thisBranding;
                }
                if (thisLocale != null) {
                    name = name + '_' + thisLocale;
                }
                name = name + ".jar";
                thisjar = new File(new File(this.jarFile.getParentFile(), "locale"), name);
                localeMarks.put(thisjar, thisLocale != null ? thisLocale : "-");
                brandingMarks.put(thisjar, thisBranding != null ? thisBranding : "-");
            } else {
                thisjar = this.jarFile;
                localeMarks.put(thisjar, null);
                brandingMarks.put(thisjar, null);
            }
            jars.add(thisjar);
            TreeMap<String, File> files2 = (TreeMap<String, File>)router.get(thisjar);
            if (files2 == null) {
                files2 = new TreeMap<String, File>();
                router.put(thisjar, files2);
            }
            files2.put(path, file);
        }
        ArrayList jars2 = new ArrayList(jars);
        class FileNameComparator
        implements Comparator {
            FileNameComparator() {
            }

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return f1.toString().compareTo(f2.toString());
            }
        }
        FileNameComparator c2 = new FileNameComparator();
        Collections.sort(jars2, c2);
        Iterator it5 = jars2.iterator();
        while (it5.hasNext()) {
            File jar = (File)it5.next();
            Map files3 = (Map)router.get(jar);
            if (jar.exists()) {
                long time = jar.lastModified();
                if (this.manifest == null || this.manifest.lastModified() <= time) {
                    boolean upToDate = true;
                    it2 = files3.values().iterator();
                    while (it2.hasNext()) {
                        File f = (File)it2.next();
                        if (f.lastModified() <= time) continue;
                        upToDate = false;
                        break;
                    }
                    if (upToDate) continue;
                }
            }
            this.log("Building localized jar: " + jar);
            IOException closing = null;
            try {
                jar.getParentFile().mkdirs();
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(jar));
                try {
                    Manifest mani;
                    long time;
                    InputStream is;
                    out.setMethod(this.doCompress ? 8 : 0);
                    String localeMark = (String)localeMarks.get(jar);
                    String brandingMark = (String)brandingMarks.get(jar);
                    TreeSet addedDirs = new TreeSet();
                    if (this.manifest != null && localeMark == null && brandingMark == null) {
                        is = new FileInputStream(this.manifest);
                        time = this.manifest.lastModified();
                    } else {
                        is = (class$org$apache$tools$ant$taskdefs$MatchingTask == null ? LocalizedJar.class$("org.apache.tools.ant.taskdefs.MatchingTask") : class$org$apache$tools$ant$taskdefs$MatchingTask).getResourceAsStream("/org/apache/tools/ant/defaultManifest.mf");
                        time = System.currentTimeMillis();
                    }
                    try {
                        mani = new Manifest(is);
                    }
                    finally {
                        is.close();
                    }
                    Attributes attr = mani.getMainAttributes();
                    if (!attr.containsKey(Attributes.Name.MANIFEST_VERSION)) {
                        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                    }
                    if (localeMark != null) {
                        attr.putValue("X-Informational-Archive-Locale", localeMark);
                    }
                    if (brandingMark != null) {
                        attr.putValue("X-Informational-Archive-Branding", brandingMark);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    mani.write(baos);
                    byte[] bytes = baos.toByteArray();
                    this.addToJar(new ByteArrayInputStream(bytes), new ByteArrayInputStream(bytes), out, "META-INF/MANIFEST.MF", time, addedDirs);
                    Iterator it22 = files3.entrySet().iterator();
                    while (it22.hasNext()) {
                        Map.Entry entry = it22.next();
                        String path = (String)entry.getKey();
                        File file = (File)entry.getValue();
                        this.addToJar(new FileInputStream(file), new FileInputStream(file), out, path, file.lastModified(), addedDirs);
                    }
                    this.writeSrcDir();
                    if (this.doIndex) {
                        this.createIndexList(jar, out, addedDirs);
                    }
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        closing = ex;
                    }
                }
                if (closing == null) continue;
                throw closing;
            }
            catch (IOException ioe) {
                String msg = "Problem creating JAR: " + ioe.getMessage();
                if (!jar.delete()) {
                    msg = msg + " (and the JAR is probably corrupt but I could not delete it)";
                }
                throw new BuildException(msg, (Throwable)ioe, this.location);
            }
        }
    }

    private void createIndexList(File zipFile, ZipOutputStream zOut, Set addedDirs) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(zipFile.getName());
        Iterator it = addedDirs.iterator();
        while (it.hasNext()) {
            String dir = (String)it.next();
            int pos = (dir = dir.replace('\\', '/')).lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            if (dir.startsWith("META-INF")) continue;
            writer.println(dir);
        }
        writer.flush();
        byte[] bytes = baos.toByteArray();
        this.addToJar(new ByteArrayInputStream(bytes), new ByteArrayInputStream(bytes), zOut, "META-INF/INDEX.LIST", System.currentTimeMillis(), addedDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToJar(InputStream in1, InputStream in2, ZipOutputStream out, String path, long lastModified, Set addedDirs) throws IOException {
        try {
            int read;
            if (path.endsWith("/")) {
                throw new IOException("Bad path: " + path);
            }
            int pos = -1;
            while ((pos = path.indexOf(47, pos + 1)) != -1) {
                String dir = path.substring(0, pos + 1);
                if (addedDirs.contains(dir)) continue;
                addedDirs.add(dir);
                ZipEntry ze = new ZipEntry(dir);
                ze.setSize(0L);
                ze.setMethod(0);
                ze.setCrc(emptyCrc);
                ze.setTime(lastModified);
                out.putNextEntry(ze);
            }
            ZipEntry ze = new ZipEntry(path);
            ze.setMethod(this.doCompress ? 8 : 0);
            ze.setTime(lastModified);
            long size = 0L;
            CRC32 crc = new CRC32();
            byte[] buf = new byte[4096];
            while ((read = in1.read(buf)) != -1) {
                crc.update(buf, 0, read);
                size += (long)read;
            }
            in1.close();
            ze.setCrc(crc.getValue());
            ze.setSize(size);
            out.putNextEntry(ze);
            while ((read = in2.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            in2.close();
            in1.close();
        }
    }

    protected String checkInLocaleDir(File file, List locales) {
        if (!this.checkPathLocale) {
            return null;
        }
        String ret = null;
        String path = file.getPath();
        Iterator iter = locales.iterator();
        while (iter.hasNext()) {
            String loc = (String)iter.next();
            String locale_dir = new String(File.separator);
            locale_dir = locale_dir + loc;
            int idx = path.indexOf(locale_dir = locale_dir + File.separator);
            if (idx == -1) continue;
            ret = loc;
            break;
        }
        return ret;
    }

    protected void addGlobalLocaleAndBranding() {
        this.addGlobals(this.getGlobalLocaleVarName(), this.locales);
        this.addGlobals(this.getOldGlobalLocaleVarName(), this.locales);
        this.addGlobals(this.getGlobalBrandingVarName(), this.brandings);
        this.addGlobals(this.getOldGlobalBrandingVarName(), this.brandings);
    }

    protected String getGlobalLocaleVarName() {
        return new String("locjar.locales");
    }

    protected String getGlobalBrandingVarName() {
        return new String("locjar.brands");
    }

    protected String getOldGlobalLocaleVarName() {
        return new String("locjar_global_locales");
    }

    protected String getOldGlobalBrandingVarName() {
        return new String("locjar_global_brands");
    }

    protected void addGlobals(String var_name, List list) {
        String prop = null;
        StringTokenizer tokenizer = null;
        String tok = null;
        LocaleOrB lorb = null;
        prop = this.getProject().getProperty(var_name);
        if (prop != null && !prop.equals("")) {
            tokenizer = new StringTokenizer(prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                tok = tokenizer.nextToken();
                lorb = new LocaleOrB();
                lorb.setName(tok);
                list.add(lorb);
            }
        }
    }

    protected boolean shouldWarnMissingDir() {
        boolean ret = false;
        if (this.warnMissingDirSet) {
            ret = this.warnMissingDir;
        } else {
            String s = this.project.getProperty("locjar.warnMissingDir");
            if (s != null && !s.trim().equals("")) {
                ret = Project.toBoolean((String)s);
            }
        }
        return ret;
    }

    protected boolean warnIfMissingDir() {
        ListIterator iter;
        boolean ret = false;
        if (this.baseDir != null && !this.baseDir.exists()) {
            ret = true;
            this.printMissingDirWarning(this.baseDir);
        }
        if ((iter = this.filesets.listIterator()) != null) {
            while (iter.hasNext()) {
                FileSet fileset = (FileSet)iter.next();
                File dir = fileset.getDir(this.project);
                if (dir == null || dir.exists()) continue;
                ret = true;
                this.printMissingDirWarning(dir);
            }
        }
        return ret;
    }

    protected void printMissingDirWarning(File dir) {
        this.log("WARNING: Skipping this task: Directory " + dir.getPath() + " doesn't exist.");
    }

    protected boolean shouldWriteSrcDir() {
        boolean ret = false;
        String s = this.project.getProperty("locjar.writeSrcDir");
        if (s != null) {
            if (Project.toBoolean((String)s)) {
                ret = true;
            }
        }
        return ret;
    }

    protected void writeSrcDir() {
        if (this.shouldWriteSrcDir() && this.jarFile != null && this.baseDir != null) {
            String name = this.jarFile.getPath();
            int fromIdx = this.getNetbeansStartIdx();
            int idx = name.indexOf(File.separator + "netbeans" + File.separator, fromIdx);
            if (idx != -1) {
                try {
                    File file = new File(name.substring(0, idx) + File.separator + "srcdir.properties");
                    FileOutputStream fos = new FileOutputStream(file);
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    osw.write("srcdir=" + this.baseDir + "\n");
                    osw.close();
                    fos.close();
                }
                catch (Exception e) {
                    System.out.println("ERROR: " + e.getMessage());
                    e.printStackTrace();
                    throw new BuildException();
                }
            } else {
                throw new BuildException("ERROR: Couldn't find netbeans dir to write srcdir.properties to.");
            }
        }
    }

    protected int getNetbeansStartIdx() {
        int startIdx = 0;
        int idx = this.baseDir.getPath().lastIndexOf(File.separator + "netbeans" + File.separator);
        if (idx != -1) {
            startIdx = idx + 1;
        }
        return startIdx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class LocaleOrB {
        String n;

        public void setName(String n) {
            this.n = n;
        }
    }
}

