/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Postprocess
extends Task {
    private File file;
    private String oldString;
    private String newString;
    private int min = 0;
    private int max = 1;

    public void setFile(File f) {
        this.file = f;
    }

    public void setOld(String s) {
        this.oldString = s;
    }

    public void setNew(String s) {
        this.newString = s;
    }

    public void setMin(int m) {
        this.min = m;
    }

    public void setMax(int m) {
        this.max = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block13: {
            if (this.file == null) {
                throw new BuildException("A file must be specified");
            }
            if (this.oldString == null || this.newString == null || this.oldString.length() != this.newString.length()) {
                throw new BuildException("New and old strings must be specified and they must have the same length");
            }
            try {
                int len = (int)this.file.length();
                byte[] b = new byte[len];
                FileInputStream is = new FileInputStream(this.file);
                try {
                    if (is.read(b) != len) {
                        throw new BuildException("Failed to read whole file", this.location);
                    }
                }
                finally {
                    is.close();
                }
                int cnt = this.replaceString(b);
                if (cnt < this.min || cnt > this.max) {
                    throw new BuildException("String " + this.oldString + " found " + cnt + " times, that is out of min/max range");
                }
                if (cnt <= 0) break block13;
                this.log("Replaced `" + this.oldString + "' by `" + this.newString + "' " + cnt + " times in " + this.file);
                FileOutputStream os = new FileOutputStream(this.file);
                try {
                    os.write(b);
                }
                finally {
                    os.close();
                }
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private int replaceString(byte[] b) {
        try {
            String arr = new String(b, "ISO8859_1");
            int cnt = 0;
            int pos = -1;
            byte[] newbytes = this.newString.getBytes("ISO8859_1");
            if (newbytes.length != this.oldString.getBytes("ISO8859_1").length) {
                throw new BuildException("Strings to replace must be equal in length", this.location);
            }
            while ((pos = arr.indexOf(this.oldString, pos + 1)) != -1) {
                System.arraycopy(newbytes, 0, b, pos, newbytes.length);
                ++cnt;
            }
            return cnt;
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Error replacing text", (Throwable)e, this.location);
        }
    }
}

