/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

public class SimpleMerge
extends Task {
    private File dest;
    private Vector modules = new Vector();
    private List topdirs = new ArrayList();
    private List subdirs = new ArrayList();

    public void setDest(File f) {
        this.dest = f;
    }

    public void setModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ", ");
        this.modules = new Vector();
        while (tok.hasMoreTokens()) {
            this.modules.addElement(tok.nextToken());
        }
    }

    public void setTopdir(File t) {
        this.topdirs.add(t);
    }

    public Topdir createTopdir() {
        return new Topdir();
    }

    public void setSubdir(String t) {
        this.subdirs.add(t);
    }

    public Subdir createSubdir() {
        return new Subdir();
    }

    public void execute() throws BuildException {
        if (this.topdirs.isEmpty()) {
            throw new BuildException("You must set at least one topdir attribute", this.location);
        }
        if (this.subdirs.isEmpty()) {
            throw new BuildException("You must set at least one subdir attribute", this.location);
        }
        this.log("Starting merge to " + this.dest.getAbsolutePath());
        for (int j = 0; j < this.topdirs.size(); ++j) {
            File topdir = (File)this.topdirs.get(j);
            for (int i = 0; i < this.modules.size(); ++i) {
                String module = (String)this.modules.elementAt(i);
                for (int h = 0; h < this.subdirs.size(); ++h) {
                    String sdir = (String)this.subdirs.get(h);
                    File subdir = new File(new File(topdir, module), sdir);
                    if (!subdir.exists()) {
                        this.log("Dir " + subdir + " does not exist, skipping...", 1);
                        continue;
                    }
                    Copy copy = (Copy)this.project.createTask("copy");
                    FileSet fs = new FileSet();
                    fs.setDir(subdir);
                    copy.addFileset(fs);
                    copy.setTodir(this.dest);
                    copy.setIncludeEmptyDirs(true);
                    copy.init();
                    copy.setLocation(this.location);
                    copy.execute();
                }
            }
        }
        this.log("Merge finished");
    }

    public class Subdir {
        public void setPath(String t) {
            SimpleMerge.this.subdirs.add(t);
        }
    }

    public class Topdir {
        public void setPath(File t) {
            SimpleMerge.this.topdirs.add(t);
        }
    }
}

