/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import com.sun.resolver.Catalog;
import com.sun.resolver.tools.ResolvingXMLReader;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidate
extends MatchingTask {
    protected File baseDir = null;
    protected ValidatorErrorHandler errorHandler = null;
    protected File catalogFile = null;
    protected boolean warnings = false;

    public void setBasedir(File baseDir) {
        if (baseDir.isDirectory()) {
            this.baseDir = baseDir;
        }
    }

    public void setCatalog(File catalog) {
        this.catalogFile = catalog;
    }

    public void setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    public void execute() throws BuildException {
        File file = null;
        try {
            ResolvingXMLReader reader = new ResolvingXMLReader();
            Catalog catalog = reader.getCatalog();
            this.errorHandler = new ValidatorErrorHandler(this.warnings);
            if (this.catalogFile != null) {
                catalog.parseCatalog(this.catalogFile.getAbsolutePath());
            }
            if (this.baseDir == null) {
                this.baseDir = this.getProject().getBaseDir();
            }
            DirectoryScanner ds = this.getDirectoryScanner(this.baseDir);
            ds.scan();
            String[] included = ds.getIncludedFiles();
            this.log(new Integer(included.length).toString() + " file(s) to validate/parse");
            for (int i = 0; i < included.length; ++i) {
                file = new File(this.baseDir, included[i]);
                if (!(file.canRead() && file.exists() && file.isFile())) {
                    throw new BuildException("Couldn't read file " + file);
                }
                InputSource is = new InputSource(file.getPath());
                this.errorHandler.init(file.getPath());
                reader.setErrorHandler((ErrorHandler)this.errorHandler);
                reader.parse(is);
                this.log(file + " file have been successfully validated.");
            }
        }
        catch (SAXException ex) {
            if (file != null) {
                throw new BuildException(ex.getMessage() + ": Can't parse " + file.getPath());
            }
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
    }

    protected class ValidatorErrorHandler
    extends DefaultHandler {
        String fileName = null;
        private boolean warn = true;

        public ValidatorErrorHandler(boolean warnings) {
            this.warn = warnings;
        }

        public void init(String fileName) {
            this.fileName = fileName;
        }

        public void fatalError(SAXParseException exception) {
            XMLValidate.this.log("[FatalError] " + this.fileName + ": " + exception.getMessage());
        }

        public void error(SAXParseException exception) {
            XMLValidate.this.log("[Error] " + this.fileName + ": " + exception.getMessage());
        }

        public void warning(SAXParseException exception) {
            if (this.warn) {
                XMLValidate.this.log("[Warning] " + this.fileName + ": " + exception.getMessage());
            }
        }
    }
}

