/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tlddoc;

import com.sun.tlddoc.GeneratorException;
import com.sun.tlddoc.TLDDocGenerator;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.transform.TransformerException;

public class TLDDoc {
    private static final String USAGE = "Tag Library Documentation Generator 1.2 by Mark Roth, Sun Microsystems, Inc.\nUsage: tlddoc [options] taglib1 [taglib2 [taglib3 ...]]\nOptions:\n  -help                  Displays this help message\n  -xslt <directory>      Use the XSLT files in the given directory\n                         instead of the defaults.\n  -d <directory>         Destination directory for output files\n                         (defaults to new dir called 'out')\n  -doctitle <html-code>  Include title for the TLD index (first) page\n  -windowtitle <text>    Browser window title\n  -q                     Quiet Mode\ntaglib{1,2,3,...}:\n  * If the path is a file that ends in .tld, process an\n    individual TLD file.\n  * If the path is a file that ends in .jar, process a\n    tag library JAR file.\n  * If the path is a file that ends in .war, process all\n    tag libraries in this web application.\n  * If the path is a directory that includes /WEB-INF/tags\n    process the implicit tag library for the given directory\n    of tag files.\n  * If the path is a directory containing a WEB-INF subdirectory,\n    process all tag libraries in this web application.\n  * Otherwise, error.";

    public static void main(String[] args) {
        TLDDocGenerator generator = new TLDDocGenerator();
        Iterator<String> iter = Arrays.asList(args).iterator();
        boolean atLeastOneTLD = false;
        try {
            while (iter.hasNext()) {
                String arg = iter.next();
                if (arg.equals("-xslt")) {
                    arg = iter.next();
                    generator.setXSLTDirectory(new File(arg));
                    continue;
                }
                if (arg.equals("-d")) {
                    arg = iter.next();
                    generator.setOutputDirectory(new File(arg));
                    continue;
                }
                if (arg.equals("-help")) {
                    TLDDoc.usage(null);
                    continue;
                }
                if (arg.equals("-q")) {
                    generator.setQuiet(true);
                    continue;
                }
                if (arg.equals("-doctitle")) {
                    arg = iter.next();
                    generator.setDocTitle(arg);
                    continue;
                }
                if (arg.equals("-windowtitle")) {
                    arg = iter.next();
                    generator.setWindowTitle(arg);
                    continue;
                }
                if (arg.equals("-webapp")) {
                    arg = iter.next();
                    File dir = new File(arg);
                    if (dir.exists()) {
                        atLeastOneTLD = true;
                        generator.addWebApp(dir);
                        continue;
                    }
                    TLDDoc.usage("Web app not found: " + arg);
                    continue;
                }
                if (arg.equals("-jar")) {
                    arg = iter.next();
                    File jar = new File(arg);
                    if (jar.exists()) {
                        atLeastOneTLD = true;
                        generator.addJAR(jar);
                        continue;
                    }
                    TLDDoc.usage("JAR not found: " + arg);
                    continue;
                }
                if (arg.equals("-tagdir")) {
                    arg = iter.next();
                    File tagdir = new File(arg);
                    if (tagdir.exists()) {
                        atLeastOneTLD = true;
                        generator.addTagDir(tagdir);
                        continue;
                    }
                    TLDDoc.usage("Tag Directory not found: " + arg);
                    continue;
                }
                File f = new File(arg);
                if (f.exists()) {
                    if (f.getName().toLowerCase().endsWith(".tld")) {
                        generator.addTLD(f);
                        atLeastOneTLD = true;
                        continue;
                    }
                    if (f.getName().toLowerCase().endsWith(".jar")) {
                        generator.addJAR(f);
                        atLeastOneTLD = true;
                        continue;
                    }
                    if (f.getName().toLowerCase().endsWith(".war")) {
                        generator.addWAR(f);
                        atLeastOneTLD = true;
                        continue;
                    }
                    if (f.isDirectory()) {
                        if (f.getAbsolutePath().replace(File.separatorChar, '/').indexOf("/WEB-INF/tags") != -1) {
                            generator.addTagDir(f);
                            atLeastOneTLD = true;
                            continue;
                        }
                        boolean foundWebInf = false;
                        File[] files = f.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].getName().toUpperCase().equals("WEB-INF") || !files[i].isDirectory()) continue;
                            foundWebInf = true;
                        }
                        if (foundWebInf) {
                            generator.addWebApp(f);
                            atLeastOneTLD = true;
                            continue;
                        }
                        TLDDoc.usage("Cannot determine tag library type for " + f.getAbsolutePath());
                        continue;
                    }
                    TLDDoc.usage("Cannot determine tag library type for " + f.getAbsolutePath());
                    continue;
                }
                TLDDoc.usage("File/directory not found: " + arg);
            }
            if (!atLeastOneTLD) {
                TLDDoc.usage("Please specify at least one TLD file.");
            }
        }
        catch (NoSuchElementException e) {
            TLDDoc.usage("Invalid Syntax.");
        }
        try {
            generator.generate();
        }
        catch (GeneratorException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private static void usage(String message) {
        if (message != null) {
            System.out.println("Error: " + message);
        }
        System.out.println(USAGE);
        System.exit(0);
    }
}

