/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tlddoc;

import com.sun.tlddoc.GeneratorException;
import com.sun.tlddoc.TagLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WARJARTLDFileTagLibrary
extends TagLibrary {
    private File war;
    private String warEntryName;
    private String tldPath;

    public WARJARTLDFileTagLibrary(File war, String warEntryName, String tldPath) {
        this.war = war;
        this.warEntryName = warEntryName;
        this.tldPath = tldPath;
    }

    public String getPathDescription() {
        return this.war.getAbsolutePath() + "!" + this.warEntryName + "!" + this.tldPath;
    }

    public InputStream getResource(String path) throws IOException {
        JarEntry jarEntry;
        JarInputStream result = null;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        JarFile warFile = new JarFile(this.war);
        JarEntry warEntry = warFile.getJarEntry(this.warEntryName);
        JarInputStream in = new JarInputStream(warFile.getInputStream(warEntry));
        while ((jarEntry = in.getNextJarEntry()) != null) {
            if (!jarEntry.getName().equals(path)) continue;
            result = in;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getTLDDocument(DocumentBuilder documentBuilder) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, GeneratorException {
        JarEntry jarEntry;
        Document result = null;
        JarFile warFile = new JarFile(this.war);
        JarEntry warEntry = warFile.getJarEntry(this.warEntryName);
        JarInputStream in = new JarInputStream(warFile.getInputStream(warEntry));
        while ((jarEntry = in.getNextJarEntry()) != null) {
            if (!jarEntry.getName().equals(this.tldPath)) continue;
            try {
                InputSource source = new InputSource(in);
                result = documentBuilder.parse(source);
                break;
            }
            finally {
                in.close();
            }
        }
        warFile.close();
        return result;
    }
}

