/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final byte[] ENCODING_TABLE;
    private static final byte PADDING_BYTE;

    private Base64() {
    }

    public static String encode(String input) {
        try {
            return Base64.encode(input, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Theoretically impossible: ISO-8859-1 (us-ascii) is not a supported encoding");
        }
    }

    public static String encode(String input, String characterEncoding) throws UnsupportedEncodingException {
        return new String(Base64.encode(input.getBytes(characterEncoding)), characterEncoding);
    }

    public static byte[] encode(byte[] array) {
        byte[] input;
        int paddingCharCount = (3 - array.length % 3) % 3;
        if (paddingCharCount == 0) {
            input = array;
        } else {
            input = new byte[array.length + paddingCharCount];
            System.arraycopy(array, 0, input, 0, array.length);
        }
        byte[] output = new byte[input.length * 4 / 3];
        int outputIndex = 0;
        int i = 0;
        while (i < input.length) {
            byte byte1 = input[i];
            byte byte2 = input[i + 1];
            byte byte3 = input[i + 2];
            output[outputIndex++] = ENCODING_TABLE[(byte1 & 0xFC) >>> 2];
            output[outputIndex++] = ENCODING_TABLE[(byte1 & 3) << 4 | (byte2 & 0xF0) >>> 4];
            output[outputIndex++] = ENCODING_TABLE[(byte2 & 0xF) << 2 | (byte3 & 0xC0) >>> 6];
            output[outputIndex++] = ENCODING_TABLE[byte3 & 0x3F];
            i += 3;
        }
        if (paddingCharCount > 1) {
            output[--outputIndex] = PADDING_BYTE;
        }
        if (paddingCharCount > 0) {
            output[--outputIndex] = PADDING_BYTE;
        }
        return output;
    }

    static {
        String table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        try {
            ENCODING_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes("ISO-8859-1");
            PADDING_BYTE = "=".getBytes("ISO-8859-1")[0];
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Theoretically impossible: ISO-8859-1 (us-ascii) is not a supported encoding");
        }
        if (ENCODING_TABLE.length != 64) {
            throw new IllegalStateException("Encoding table doesn't contain 64 values");
        }
    }
}

