/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Base64;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SimpleLog;

public class HttpWebConnection
extends WebConnection {
    private final Map httpClients_ = new HashMap(9);

    public HttpWebConnection(WebClient webClient) {
        super(webClient);
    }

    public HttpWebConnection(WebClient webClient, String proxyHost, int proxyPort) {
        super(webClient, proxyHost, proxyPort);
    }

    public WebResponse getResponse(URL url, SubmitMethod submitMethod, List parameters, Map requestHeaders) throws IOException {
        HttpClient httpClient = this.getHttpClientFor(url);
        try {
            KeyValuePair pair;
            HttpMethod httpMethod = this.makeHttpMethod(url, submitMethod, parameters, requestHeaders);
            long startTime = System.currentTimeMillis();
            int responseCode = httpClient.executeMethod(httpMethod);
            long endTime = System.currentTimeMillis();
            if (responseCode == 401 && (pair = this.getCredentials(httpMethod, url)) != null) {
                httpMethod = this.makeHttpMethod(url, submitMethod, parameters, requestHeaders);
                this.addCredentialsToHttpMethod(httpMethod, pair);
                startTime = System.currentTimeMillis();
                responseCode = httpClient.executeMethod(httpMethod);
                endTime = System.currentTimeMillis();
            }
            return this.makeWebResponse(responseCode, httpMethod, url, endTime - startTime);
        }
        catch (HttpException e) {
            if (url.getPath().length() == 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(url.getProtocol());
                buffer.append("://");
                buffer.append(url.getHost());
                buffer.append("/");
                if (url.getQuery() != null) {
                    buffer.append(url.getQuery());
                }
                return this.getResponse(new URL(buffer.toString()), submitMethod, parameters, requestHeaders);
            }
            e.printStackTrace();
            throw new RuntimeException("HTTP Error: " + e.getMessage());
        }
    }

    private KeyValuePair getCredentials(HttpMethod httpMethod, URL url) {
        Header challengeHeader = httpMethod.getResponseHeader("WWW-Authenticate");
        String realmString = challengeHeader.getValue().trim();
        String tag = "realm=\"";
        int index = realmString.indexOf("realm=\"");
        if (index == -1 || realmString.charAt(realmString.length() - 1) != '\"') {
            throw new IllegalStateException("Unable to parse the 'WWW-Authenticate' header - can't do authentication");
        }
        int port = url.getPort();
        if (port == -1) {
            String protocol = url.getProtocol();
            if (protocol.equals("http")) {
                port = 80;
            } else if (protocol.equals("https")) {
                port = 443;
            } else {
                throw new IllegalStateException("Unsupported protocol: " + protocol);
            }
        }
        String realm = realmString.substring(index + "realm=\"".length(), realmString.length() - 1);
        KeyValuePair pair = this.getWebClient().getCredentialProvider().getCredentialsFor(url.getHost(), port, realm);
        return pair;
    }

    private HttpMethod makeHttpMethod(URL url, SubmitMethod method, List parameters, Map requestHeaders) throws IOException {
        GetMethod httpMethod;
        String path = url.getPath();
        if (path.length() == 0) {
            path = "/";
        }
        if (method == SubmitMethod.GET) {
            httpMethod = new GetMethod(path);
            if (parameters.isEmpty()) {
                String queryString = url.getQuery();
                httpMethod.setQueryString(queryString);
            } else {
                NameValuePair[] pairs = new NameValuePair[parameters.size()];
                parameters.toArray(pairs);
                httpMethod.setQueryString(pairs);
            }
        } else if (method == SubmitMethod.POST) {
            NameValuePair pair;
            httpMethod = new PostMethod(path);
            String queryString = url.getQuery();
            if (queryString != null) {
                httpMethod.setQueryString(queryString);
            }
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                pair = (NameValuePair)iterator.next();
                ((PostMethod)httpMethod).removeParameter(pair.getName(), pair.getValue());
            }
            iterator = parameters.iterator();
            while (iterator.hasNext()) {
                pair = (NameValuePair)iterator.next();
                ((PostMethod)httpMethod).addParameter(pair.getName(), pair.getValue());
            }
        } else {
            throw new IllegalStateException("Submit method not yet supported: " + method);
        }
        httpMethod.setRequestHeader("User-Agent", this.getWebClient().getBrowserVersion().getUserAgent());
        this.writeRequestHeadersToHttpMethod((HttpMethod)httpMethod, requestHeaders);
        httpMethod.setFollowRedirects(false);
        return httpMethod;
    }

    private synchronized HttpClient getHttpClientFor(URL url) {
        String key = url.getProtocol() + "://" + url.getHost().toLowerCase();
        HttpClient client = (HttpClient)this.httpClients_.get(key);
        if (client == null) {
            URI uri;
            client = new HttpClient();
            Log log = LogFactory.getLog((String)"httpclient.wire");
            if (log instanceof SimpleLog) {
                ((SimpleLog)log).setLevel(4);
            }
            HttpState httpState = new HttpState(){

                public void setCredentials(String realm, String host, Credentials credentials) {
                }

                public Credentials getCredentials(String realm, String host) {
                    return null;
                }
            };
            client.setState(httpState);
            httpState.setCookiePolicy(0);
            HostConfiguration hostConfiguration = new HostConfiguration();
            try {
                uri = new URI(url.toExternalForm());
            }
            catch (URIException e) {
                throw new IllegalStateException("Unable to create URI from URL: " + url.toExternalForm());
            }
            hostConfiguration.setHost(uri);
            if (this.getProxyHost() != null) {
                hostConfiguration.setProxy(this.getProxyHost(), this.getProxyPort());
            }
            client.setHostConfiguration(hostConfiguration);
            HttpState sharedState = this.getStateForUrl(url);
            if (sharedState != null) {
                client.setState(sharedState);
            }
            this.httpClients_.put(key, client);
        }
        return client;
    }

    public synchronized HttpState getStateForUrl(URL url) {
        String domain = url.getHost();
        int index = domain.lastIndexOf(46);
        if (index != -1) {
            index = domain.lastIndexOf(".", index - 1);
        }
        String rootDomain = index == -1 ? domain : domain.substring(index + 1);
        Iterator iterator = this.httpClients_.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String host = (String)entry.getKey();
            if (!host.equals(rootDomain) && !host.endsWith("." + rootDomain)) continue;
            return ((HttpClient)entry.getValue()).getState();
        }
        return null;
    }

    private WebResponse makeWebResponse(final int statusCode, final HttpMethod method, final URL originatingURL, final long loadTime) {
        final byte[] contentBuffer = method.getResponseBody();
        final String contentAsString = method.getResponseBodyAsString();
        return new WebResponse(){

            public int getStatusCode() {
                return statusCode;
            }

            public String getStatusMessage() {
                String message = method.getStatusText();
                if (message == null || message.length() == 0) {
                    message = HttpStatus.getStatusText((int)statusCode);
                }
                if (message == null) {
                    message = "Unknown status code";
                }
                return message;
            }

            public String getContentType() {
                Header contentTypeHeader = method.getResponseHeader("content-type");
                if (contentTypeHeader == null) {
                    return "";
                }
                String contentTypeHeaderLine = contentTypeHeader.getValue();
                int index = contentTypeHeaderLine.indexOf(59);
                if (index == -1) {
                    return contentTypeHeaderLine;
                }
                return contentTypeHeaderLine.substring(0, index);
            }

            public String getContentAsString() throws IOException {
                return contentAsString;
            }

            public InputStream getContentAsStream() throws IOException {
                return new ByteArrayInputStream(contentBuffer);
            }

            public URL getUrl() {
                return originatingURL;
            }

            public String getResponseHeaderValue(String headerName) {
                Header header = method.getResponseHeader(headerName);
                if (header == null) {
                    return null;
                }
                return header.getValue();
            }

            public long getLoadTimeInMilliSeconds() {
                return loadTime;
            }

            public String getContentCharSet() {
                if (method instanceof HttpMethodBase) {
                    return ((HttpMethodBase)method).getResponseCharSet();
                }
                return "ISO-8859-1";
            }

            public byte[] getResponseBody() {
                return contentBuffer;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequestHeadersToHttpMethod(HttpMethod httpMethod, Map requestHeaders) {
        Map map = requestHeaders;
        synchronized (map) {
            Iterator iterator = requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                httpMethod.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void addCredentialsToHttpMethod(HttpMethod httpMethod, KeyValuePair pair) {
        String userName = pair.getKey();
        String password = pair.getValue();
        String authString = userName + ":" + password;
        String value = "Basic " + Base64.encode(authString);
        httpMethod.addRequestHeader("Authorization", value);
    }
}

