/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.Reader;
import java.io.StringReader;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;

public final class ScriptFilter
extends DefaultFilter {
    private final HTMLConfiguration configuration_;
    private final HtmlPage htmlPage_;
    private String scriptSource_;
    private String scriptCharset_;
    private StringBuffer scriptBuffer_;
    private StringBuffer newContentBuffer_;
    private String systemId_;
    private int scriptCount_;

    public ScriptFilter(HTMLConfiguration config, HtmlPage htmlPage) {
        Assert.notNull("config", config);
        Assert.notNull("htmlPage", htmlPage);
        this.configuration_ = config;
        this.htmlPage_ = htmlPage;
        this.htmlPage_.setScriptFilter(this);
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augmentations) throws XNIException {
        this.scriptSource_ = null;
        this.scriptCharset_ = null;
        this.scriptBuffer_ = null;
        this.systemId_ = locator != null ? locator.getLiteralSystemId() : null;
        this.scriptCount_ = 0;
        super.startDocument(locator, encoding, augmentations);
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augmentations) throws XNIException {
        boolean isJavaScript;
        if (element.rawname.equalsIgnoreCase("script") && (isJavaScript = this.htmlPage_.isJavaScript(attrs.getValue("type"), attrs.getValue("language")))) {
            String src = attrs.getValue("src");
            String charset = attrs.getValue("charset");
            if (src != null && src.length() != 0) {
                this.scriptSource_ = src;
                this.scriptCharset_ = charset;
            }
            this.scriptBuffer_ = new StringBuffer();
        }
        super.startElement(element, attrs, augmentations);
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augmentations) throws XNIException {
        super.emptyElement(element, attrs, augmentations);
    }

    public void characters(XMLString text, Augmentations augmentations) throws XNIException {
        if (this.scriptBuffer_ == null) {
            super.characters(text, augmentations);
        } else {
            super.characters(text, augmentations);
            this.scriptBuffer_.append(text.ch, text.offset, text.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(QName element, Augmentations augmentations) throws XNIException {
        super.endElement(element, augmentations);
        if (this.scriptBuffer_ != null) {
            if (!element.rawname.equalsIgnoreCase("script")) {
                throw new IllegalStateException("Other elements were contained within the script tag");
            }
            try {
                if (this.scriptSource_ != null) {
                    String result = this.loadScript(this.scriptSource_, this.scriptCharset_);
                    this.pushResult(result);
                }
                String script = this.scriptBuffer_.toString();
                String result = this.executeScript(script);
                this.pushResult(result);
            }
            finally {
                this.scriptSource_ = null;
                this.scriptCharset_ = null;
                this.scriptBuffer_ = null;
            }
        }
    }

    private synchronized String loadScript(String scriptSource, String scriptCharset) {
        this.newContentBuffer_ = null;
        this.htmlPage_.loadExternalJavaScriptFile(scriptSource, scriptCharset);
        if (this.newContentBuffer_ != null) {
            String result = this.newContentBuffer_.toString();
            this.newContentBuffer_ = null;
            return result;
        }
        return "";
    }

    private synchronized String executeScript(String script) {
        this.newContentBuffer_ = null;
        this.htmlPage_.executeJavaScriptIfPossible(script, "Embedded script", false, null);
        if (this.newContentBuffer_ == null) {
            return "";
        }
        String result = this.newContentBuffer_.toString();
        this.newContentBuffer_ = null;
        return result;
    }

    private synchronized void pushResult(String result) {
        if (result.length() != 0) {
            XMLInputSource xmlInputSource = new XMLInputSource(null, this.systemId_, null, (Reader)new StringReader(result), "UTF-8");
            this.configuration_.pushInputSource(xmlInputSource);
        }
    }

    public synchronized void write(String content) {
        if (this.newContentBuffer_ == null) {
            this.newContentBuffer_ = new StringBuffer();
        }
        this.newContentBuffer_.append(content);
    }
}

