/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class TextUtil {
    private TextUtil() {
    }

    public static boolean startsWithIgnoreCase(String stringToCheck, String prefix) {
        Assert.notNull("stringToCheck", stringToCheck);
        Assert.notNull("prefix", prefix);
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Prefix may not be empty");
        }
        int prefixLength = prefix.length();
        if (stringToCheck.length() < prefixLength) {
            return false;
        }
        return stringToCheck.substring(0, prefixLength).toLowerCase().equals(prefix.toLowerCase());
    }

    public static InputStream toInputStream(String content) {
        try {
            return TextUtil.toInputStream(content, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ISO-8859-1 is an unsupported encoding!  You may have a corrupted installation of java.");
        }
    }

    public static InputStream toInputStream(String content, String encoding) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(content.length() * 2);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, encoding);
            writer.write(content);
            writer.flush();
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            return new ByteArrayInputStream(byteArray);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception when converting a string to an input stream: " + e);
        }
    }
}

