/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.util.EventObject;

public final class WebWindowEvent
extends EventObject {
    private final Page oldPage_;
    private final Page newPage_;

    public WebWindowEvent(WebWindow source, Page oldPage, Page newPage) {
        super(source);
        this.oldPage_ = oldPage;
        this.newPage_ = newPage;
    }

    public boolean equals(Object object) {
        if (this.getClass() == object.getClass()) {
            WebWindowEvent event = (WebWindowEvent)object;
            return this.isEqual(this.getSource(), event.getSource()) && this.isEqual(this.getOldPage(), event.getOldPage()) && this.isEqual(this.getNewPage(), event.getNewPage());
        }
        return false;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public Page getOldPage() {
        return this.oldPage_;
    }

    public Page getNewPage() {
        return this.newPage_;
    }

    public WebWindow getWebWindow() {
        return (WebWindow)this.getSource();
    }

    private boolean isEqual(Object object1, Object object2) {
        boolean result = object1 == null && object2 == null ? true : (object1 == null || object2 == null ? false : object1.equals(object2));
        return result;
    }

    public String toString() {
        return "WebWindowEvent(source=[" + this.getSource() + "] oldPage=[" + this.getOldPage() + "] newPage=[" + this.getNewPage() + "])";
    }
}

