/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import org.w3c.dom.Element;

public class HtmlButton
extends HtmlElement
implements SubmittableElement {
    HtmlButton(HtmlPage page, Element element) {
        super(page, element);
    }

    public void setValueAttribute(String newValue) {
        Assert.notNull("newValue", newValue);
        this.getElement().setAttribute("value", newValue);
    }

    public Page submit() throws IllegalStateException, IOException, ElementNotFoundException {
        return this.click();
    }

    public Page click() throws IllegalStateException, IOException {
        if (this.isDisabled()) {
            return this.getPage();
        }
        String onClick = this.getOnClickAttribute();
        HtmlPage page = this.getPage();
        if (onClick.length() == 0 || !page.getWebClient().isJavaScriptEnabled()) {
            return this.getEnclosingFormOrDie().submit();
        }
        return page.executeJavaScriptIfPossible(onClick, "HtmlButton onClick handler", true, this).getNewPage();
    }

    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public void reset() {
        this.getLog().debug((Object)"reset() not implemented for this element");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeValue("value");
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }
}

