/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class HtmlElement {
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    public static final String ATTRIBUTE_VALUE_EMPTY = new String("");
    private Element element_;
    private final HtmlPage htmlPage_;
    private PropertyChangeSupport propertyChangeSupport_ = null;
    private Object scriptObject_;
    public static final String PROPERTY_ELEMENT = "element";

    protected HtmlElement(HtmlPage htmlPage, Element element) {
        if (!(this instanceof HtmlPage)) {
            Assert.notNull(PROPERTY_ELEMENT, element);
        }
        this.element_ = element;
        if (htmlPage == null && this instanceof HtmlPage) {
            this.htmlPage_ = (HtmlPage)this;
        } else {
            Assert.notNull("htmlPage", htmlPage);
            this.htmlPage_ = htmlPage;
        }
    }

    protected final void setElement(Element element) {
        Assert.notNull(PROPERTY_ELEMENT, element);
        if (this.element_ != null) {
            throw new IllegalStateException("element_ has already been set");
        }
        Element oldValue = this.element_;
        this.element_ = element;
        this.firePropertyChange(PROPERTY_ELEMENT, oldValue, element);
    }

    public Element getElement() {
        return this.element_;
    }

    protected final List getXmlElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        Assert.notNull("elementName", elementName);
        Assert.notNull("attributeName", attributeName);
        Assert.notNull("attributeValue", attributeValue);
        ArrayList<Element> collectedElements = new ArrayList<Element>();
        Iterator iterator = this.getXmlChildElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!this.getTagName(element).equals(elementName) || !this.getAttributeValue(element, attributeName).equals(attributeValue)) continue;
            collectedElements.add(element);
        }
        return collectedElements;
    }

    public final String getAttributeValue(String attributeName) {
        return this.getAttributeValue(this.getElement(), attributeName);
    }

    public final String getAttributeValue(Element element, String attributeName) {
        Assert.notNull(PROPERTY_ELEMENT, element);
        Attr attribute = element.getAttributeNode(attributeName.toUpperCase());
        if (attribute == null) {
            return ATTRIBUTE_NOT_DEFINED;
        }
        String attributeValue = attribute.getValue();
        if (attributeValue == null || attributeValue.length() == 0) {
            return ATTRIBUTE_VALUE_EMPTY;
        }
        return attributeValue;
    }

    public boolean isAttributeDefined(String attributeName) {
        return this.getAttributeValue(attributeName) != ATTRIBUTE_NOT_DEFINED;
    }

    public final String getTagName() {
        return this.getTagName(this.getElement());
    }

    public final String getTagName(Element element) {
        Assert.notNull(PROPERTY_ELEMENT, element);
        return element.getTagName().toLowerCase();
    }

    public HtmlForm getEnclosingForm() {
        Node currentNode = this.getElement().getParentNode();
        while (currentNode != null) {
            Element element;
            if (currentNode instanceof Element && this.getTagName(element = (Element)currentNode).equals("form")) {
                return (HtmlForm)this.getPage().getHtmlElement(element);
            }
            currentNode = currentNode.getParentNode();
        }
        return null;
    }

    public HtmlForm getEnclosingFormOrDie() throws IllegalStateException {
        HtmlForm form = this.getEnclosingForm();
        if (form == null) {
            throw new IllegalStateException("Element is not comtained within a form: " + this);
        }
        return form;
    }

    public String toString() {
        Element element = this.getElement();
        StringBuffer buffer = new StringBuffer();
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index == -1) {
            buffer.append(className);
        } else {
            buffer.append(className.substring(index + 1));
        }
        buffer.append("[<");
        buffer.append(this.getTagName(element));
        NamedNodeMap attributeMap = element.getAttributes();
        int attributeCount = attributeMap.getLength();
        int i = 0;
        while (i < attributeCount) {
            buffer.append(' ');
            Attr attribute = (Attr)attributeMap.item(i);
            buffer.append(attribute.getName());
            buffer.append("=\"");
            buffer.append(attribute.getValue());
            buffer.append("\"");
            ++i;
        }
        buffer.append(">]");
        return buffer.toString();
    }

    public String asText() {
        String text = this.getChildrenAsText();
        text = text.replace('\u00a0', ' ');
        text = HtmlElement.reduceWhitespace(text);
        return text;
    }

    protected final String getChildrenAsText() {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = this.getElement().getChildNodes();
        if (nodeList == null) {
            return "";
        }
        int nodeCount = nodeList.getLength();
        HtmlPage page = this.getPage();
        int i = 0;
        while (i < nodeCount) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element xmlElement = (Element)node;
                HtmlElement htmlElement = page.getHtmlElement(xmlElement);
                buffer.append(htmlElement.asText());
            } else if (!(node instanceof Comment)) {
                if (node instanceof CharacterData) {
                    buffer.append(((CharacterData)node).getData());
                } else {
                    throw new RuntimeException("Not implemented yet: getChildrenAsText() for other kinds of nodes");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static String reduceWhitespace(String text) {
        StringBuffer buffer = new StringBuffer(text.length());
        int length = text.length();
        boolean whitespace = false;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (whitespace) {
                if (!Character.isWhitespace(ch)) {
                    buffer.append(ch);
                    whitespace = false;
                }
            } else if (Character.isWhitespace(ch)) {
                whitespace = true;
                buffer.append(' ');
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString().trim();
    }

    public HtmlPage getPage() {
        return this.htmlPage_;
    }

    public Iterator getXmlChildElements() {
        final Element rootElement = this.getElement();
        if (rootElement == null) {
            throw new IllegalStateException("The xml element hasn't been set for this object.");
        }
        return new Iterator(){
            private Element nextElement;
            {
                this.nextElement = this.getFirstChildElement(rootElement);
            }

            public boolean hasNext() {
                return this.nextElement != null;
            }

            public Object next() {
                Element result = this.nextElement;
                this.moveToNext();
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void moveToNext() {
                Element next = this.getFirstChildElement(this.nextElement);
                if (next == null) {
                    next = this.getNextSibling(this.nextElement);
                }
                if (next == null) {
                    next = this.getNextElementUpwards(this.nextElement);
                }
                if (next == rootElement) {
                    next = null;
                }
                this.nextElement = next;
            }

            private Element getNextElementUpwards(Element startingElement) {
                Assert.notNull("startingElement", startingElement);
                if (startingElement == rootElement) {
                    return startingElement;
                }
                Element parent = (Element)startingElement.getParentNode();
                if (parent == rootElement) {
                    return parent;
                }
                Node next = parent.getNextSibling();
                while (next != null && !(next instanceof Element)) {
                    next = next.getNextSibling();
                }
                if (next == null) {
                    return this.getNextElementUpwards(parent);
                }
                return (Element)next;
            }

            private Element getFirstChildElement(Element parent) {
                Node node = parent.getFirstChild();
                while (node != null && !(node instanceof Element)) {
                    node = node.getNextSibling();
                }
                return (Element)node;
            }

            private Element getNextSibling(Element parent) {
                Node node = parent.getNextSibling();
                while (node != null && !(node instanceof Element)) {
                    node = node.getNextSibling();
                }
                return (Element)node;
            }
        };
    }

    public Iterator getAllHtmlChildElements() {
        final Iterator xmlIterator = this.getXmlChildElements();
        final HtmlPage page = this.getPage();
        return new Iterator(){

            public boolean hasNext() {
                return xmlIterator.hasNext();
            }

            public Object next() {
                Element xmlElement = (Element)xmlIterator.next();
                return page.getHtmlElement(xmlElement);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected final void notImplemented() {
        throw new RuntimeException("Not implemented yet");
    }

    protected final void assertNotEmpty(String description, String string) throws IllegalArgumentException {
        if (string.length() == 0) {
            throw new IllegalArgumentException("String may not be empty: " + description);
        }
    }

    public final HtmlElement getOneHtmlElementByAttribute(String elementName, String attributeName, String attributeValue) throws ElementNotFoundException {
        Assert.notNull("elementName", elementName);
        Assert.notNull("attributeName", attributeName);
        Assert.notNull("attributeValue", attributeValue);
        List list = this.getHtmlElementsByAttribute(elementName, attributeName, attributeValue);
        int listSize = list.size();
        if (listSize == 0) {
            throw new ElementNotFoundException(elementName, attributeName, attributeValue);
        }
        if (listSize > 1) {
            throw new IllegalStateException("Found more than one matching element: elementName=[" + elementName + "] attributeName=[" + attributeName + "] attributeValue=[" + attributeValue + "]");
        }
        return (HtmlElement)list.get(0);
    }

    public HtmlElement getHtmlElementById(String id) throws ElementNotFoundException {
        Assert.notNull("id", id);
        this.assertNotEmpty("id", id);
        Iterator iterator = this.getXmlChildElements();
        while (iterator.hasNext()) {
            Element xmlElement = (Element)iterator.next();
            String idValue = this.getAttributeValue(xmlElement, "id");
            if (!id.equals(idValue)) continue;
            return this.getPage().getHtmlElement(xmlElement);
        }
        throw new ElementNotFoundException("*", "id", id);
    }

    public boolean hasHtmlElementWithId(String id) {
        try {
            this.getHtmlElementById(id);
            return true;
        }
        catch (ElementNotFoundException e) {
            return false;
        }
    }

    public final List getHtmlElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        Assert.notNull("elementName", elementName);
        Assert.notNull("attributeName", attributeName);
        Assert.notNull("attributeValue", attributeValue);
        List xmlElements = this.getXmlElementsByAttribute(elementName, attributeName, attributeValue);
        ArrayList<HtmlElement> htmlElements = new ArrayList<HtmlElement>(xmlElements.size());
        HtmlPage page = this.getPage();
        Iterator iterator = xmlElements.iterator();
        while (iterator.hasNext()) {
            htmlElements.add(page.getHtmlElement((Element)iterator.next()));
        }
        return htmlElements;
    }

    public final List getHtmlElementsByTagNames(List acceptableTagNames) {
        Assert.notNull("acceptableTagNames", acceptableTagNames);
        HtmlPage page = this.getPage();
        ArrayList<HtmlElement> collectedElements = new ArrayList<HtmlElement>();
        Iterator xmlIterator = this.getXmlChildElements();
        while (xmlIterator.hasNext()) {
            Element xmlElement = (Element)xmlIterator.next();
            if (!acceptableTagNames.contains(this.getTagName(xmlElement))) continue;
            collectedElements.add(page.getHtmlElement(xmlElement));
        }
        return collectedElements;
    }

    public final URL makeUrlFromHref(String href) throws MalformedURLException {
        return this.getPage().getFullyQualifiedUrl(href);
    }

    public final List getChildElements() {
        NodeList childNodes = this.getElement().getChildNodes();
        int childCount = childNodes.getLength();
        HtmlPage page = this.getPage();
        ArrayList<HtmlElement> result = new ArrayList<HtmlElement>();
        int i = 0;
        while (i < childCount) {
            Node node = childNodes.item(i);
            if (node instanceof Element) {
                result.add(page.getHtmlElement((Element)node));
            }
            ++i;
        }
        return result;
    }

    public HtmlElement getParent() {
        return this.getPage().getHtmlElement((Element)this.getElement().getParentNode());
    }

    public HtmlElement getNextSibling() {
        return this.getPage().getHtmlElement((Element)this.getElement().getNextSibling());
    }

    public HtmlElement getPreviousSibling() {
        return this.getPage().getHtmlElement((Element)this.getElement().getPreviousSibling());
    }

    public void setScriptObject(Object scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    public Object getScriptObject() {
        return this.scriptObject_;
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public String asXml() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printXml(this.getElement(), "", printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    private void printXml(Node node, String indent, PrintWriter printWriter) {
        boolean hasChildren;
        boolean bl = hasChildren = node.getFirstChild() != null;
        if (node instanceof Element) {
            Element element = (Element)node;
            printWriter.print(indent + "<" + element.getTagName().toLowerCase());
            NamedNodeMap attributeMap = element.getAttributes();
            int attributeCount = attributeMap.getLength();
            int i = 0;
            while (i < attributeCount) {
                printWriter.print(" ");
                Attr attribute = (Attr)attributeMap.item(i);
                printWriter.print(attribute.getName().toLowerCase());
                printWriter.print("=\"");
                printWriter.print(attribute.getValue());
                printWriter.print("\"");
                ++i;
            }
            if (!hasChildren) {
                printWriter.print("/");
            }
            printWriter.println(">");
        } else if (node instanceof CharacterData) {
            printWriter.print(indent);
            printWriter.println(((CharacterData)node).getData());
        } else {
            printWriter.println(indent + node);
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.printXml(child, indent + "  ", printWriter);
            child = child.getNextSibling();
        }
        if (hasChildren && node instanceof Element) {
            printWriter.println(indent + "</" + ((Element)node).getTagName().toLowerCase() + ">");
        }
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        Assert.notNull("listener", listener);
        if (this.propertyChangeSupport_ == null) {
            this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        Assert.notNull("listener", listener);
        if (this.propertyChangeSupport_ != null) {
            this.propertyChangeSupport_.removePropertyChangeListener(listener);
        }
    }

    protected final synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport_ != null) {
            this.propertyChangeSupport_.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

