/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class HtmlForm
extends HtmlElement {
    private static final Collection SUBMITTABLE_ELEMENT_NAMES = Arrays.asList("input", "button", "select", "textarea", "isindex");
    private KeyValuePair fakeSelectedRadioButton_ = null;

    HtmlForm(HtmlPage htmlPage, Element element) throws IOException {
        super(htmlPage, element);
    }

    public Page submit(String buttonName) throws IOException, ElementNotFoundException {
        List inputList = this.getHtmlElementsByAttribute("input", "name", buttonName);
        Iterator iterator = inputList.iterator();
        while (iterator.hasNext()) {
            HtmlInput input = (HtmlInput)iterator.next();
            if (!input.getTypeAttribute().equals("submit")) continue;
            return this.submit(input);
        }
        HtmlButton button = (HtmlButton)this.getOneHtmlElementByAttribute("button", "name", buttonName);
        return this.submit(button);
    }

    public Page submit() throws IOException {
        return this.submit((SubmittableElement)null);
    }

    Page submit(SubmittableElement submitElement) throws IOException {
        URL url;
        String action = this.getActionAttribute();
        HtmlPage htmlPage = this.getPage();
        if (htmlPage.getWebClient().isJavaScriptEnabled()) {
            ScriptResult scriptResult;
            String onSubmit = this.getOnSubmitAttribute();
            if (onSubmit.length() != 0 && (scriptResult = htmlPage.executeJavaScriptIfPossible(onSubmit, "onSubmit", true, this)).getJavaScriptResult().equals(Boolean.FALSE)) {
                return scriptResult.getNewPage();
            }
            if (TextUtil.startsWithIgnoreCase(action, "javascript:")) {
                return htmlPage.executeJavaScriptIfPossible(action, "Form action", false, this).getNewPage();
            }
        } else if (TextUtil.startsWithIgnoreCase(action, "javascript:")) {
            return htmlPage;
        }
        List parameterList = this.getParameterListForSubmit(submitElement);
        try {
            url = htmlPage.getFullyQualifiedUrl(action);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Not a valid url: " + action);
        }
        SubmitMethod method = SubmitMethod.getInstance(this.getAttributeValue("method"));
        WebWindow webWindow = htmlPage.getEnclosingWindow();
        return htmlPage.getWebClient().getPage(webWindow, url, method, parameterList);
    }

    public final List getParameterListForSubmit(SubmittableElement submitElement) {
        Collection submittableElements = this.getAllSubmittableElements();
        ArrayList<KeyValuePair> parameterList = new ArrayList<KeyValuePair>(submittableElements.size());
        Iterator iterator = submittableElements.iterator();
        while (iterator.hasNext()) {
            SubmittableElement element = (SubmittableElement)iterator.next();
            KeyValuePair[] pairs = element.getSubmitKeyValuePairs();
            int i = 0;
            while (i < pairs.length) {
                parameterList.add(pairs[i]);
                ++i;
            }
        }
        if (submitElement != null) {
            KeyValuePair[] pairs = submitElement.getSubmitKeyValuePairs();
            int i = 0;
            while (i < pairs.length) {
                parameterList.add(pairs[i]);
                ++i;
            }
        }
        if (this.fakeSelectedRadioButton_ != null) {
            this.adjustParameterListToAccountForFakeSelectedRadioButton(parameterList);
        }
        return parameterList;
    }

    public Page reset() {
        ScriptResult scriptResult;
        String onReset;
        HtmlPage htmlPage = this.getPage();
        if (htmlPage.getWebClient().isJavaScriptEnabled() && (onReset = this.getOnResetAttribute()).length() != 0 && (scriptResult = htmlPage.executeJavaScriptIfPossible(onReset, "onReset", true, this)).getJavaScriptResult().equals(Boolean.FALSE)) {
            return scriptResult.getNewPage();
        }
        Iterator elementIterator = this.getAllHtmlChildElements();
        while (elementIterator.hasNext()) {
            Object next = elementIterator.next();
            if (!(next instanceof SubmittableElement)) continue;
            ((SubmittableElement)next).reset();
        }
        return htmlPage;
    }

    public Collection getAllSubmittableElements() {
        ArrayList<HtmlElement> submittableElements = new ArrayList<HtmlElement>();
        HtmlPage page = this.getPage();
        Iterator iterator = this.getXmlChildElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!this.isSubmittable(element)) continue;
            submittableElements.add(page.getHtmlElement(element));
        }
        return submittableElements;
    }

    private boolean isSubmittable(Element element) {
        String tagName = this.getTagName(element);
        if (!SUBMITTABLE_ELEMENT_NAMES.contains(tagName.toLowerCase())) {
            return false;
        }
        Attr disabled = this.getElement().getAttributeNode("disabled");
        if (disabled != null) {
            return false;
        }
        if (tagName.equals("input")) {
            String type = this.getAttributeValue(element, "type").toLowerCase();
            if (type.equals("radio") || type.equals("checkbox")) {
                Attr checked = element.getAttributeNode("checked");
                return checked != null;
            }
            if (type.equals("submit") || type.equals("image")) {
                return false;
            }
        }
        return true;
    }

    public List getAllInputsByName(String name) {
        return this.getHtmlElementsByAttribute("input", "name", name);
    }

    public final HtmlInput getInputByName(String name) throws ElementNotFoundException {
        List inputs = this.getHtmlElementsByAttribute("input", "name", name);
        if (inputs.size() == 0) {
            throw new ElementNotFoundException("input", "name", name);
        }
        return (HtmlInput)inputs.get(0);
    }

    public HtmlRadioButtonInput getRadioButtonInput(String name, String value) throws ElementNotFoundException {
        Iterator iterator = this.getRadioButtonsByName(name).iterator();
        while (iterator.hasNext()) {
            HtmlRadioButtonInput input = (HtmlRadioButtonInput)iterator.next();
            if (!input.getValueAttribute().equals(value)) continue;
            return input;
        }
        throw new ElementNotFoundException("input", "value", value);
    }

    public List getSelectsByName(String name) {
        return this.getHtmlElementsByAttribute("select", "name", name);
    }

    public HtmlSelect getSelectByName(String name) throws ElementNotFoundException {
        List list = this.getSelectsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("select", "name", name);
        }
        return (HtmlSelect)list.get(0);
    }

    public List getButtonsByName(String name) throws ElementNotFoundException {
        return this.getHtmlElementsByAttribute("button", "name", name);
    }

    public List getTextAreasByName(String name) {
        return this.getHtmlElementsByAttribute("textarea", "name", name);
    }

    public List getRadioButtonsByName(String name) {
        Assert.notNull("name", name);
        ArrayList<HtmlElement> results = new ArrayList<HtmlElement>();
        HtmlPage page = this.getPage();
        Iterator iterator = this.getXmlChildElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!this.getTagName(element).equals("input") || !this.getAttributeValue(element, "type").equalsIgnoreCase("radio") || !this.getAttributeValue(element, "name").equals(name)) continue;
            results.add(page.getHtmlElement(element));
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    public void setCheckedRadioButton(String name, String value) throws ElementNotFoundException {
        inputToSelect = this.getRadioButtonInput(name, value);
        iterator = this.getRadioButtonsByName(name).iterator();
        if (iterator.hasNext()) ** GOTO lbl10
        throw new ElementNotFoundException("input", name, value);
lbl-1000:
        // 1 sources

        {
            input = (HtmlInput)iterator.next();
            if (input == inputToSelect) {
                input.getElement().setAttribute("checked", "checked");
                continue;
            }
            input.getElement().removeAttribute("checked");
lbl10:
            // 3 sources

            ** while (iterator.hasNext())
        }
lbl11:
        // 1 sources

    }

    public final void fakeCheckedRadioButton(String name, String value) throws ElementNotFoundException {
        this.fakeSelectedRadioButton_ = new KeyValuePair(name, value);
    }

    private void adjustParameterListToAccountForFakeSelectedRadioButton(List list) {
        String fakeRadioButtonName = this.fakeSelectedRadioButton_.getKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            KeyValuePair pair = (KeyValuePair)((Object)iterator.next());
            if (!pair.getKey().equals(fakeRadioButtonName)) continue;
            iterator.remove();
        }
        list.add(this.fakeSelectedRadioButton_);
    }

    public HtmlRadioButtonInput getCheckedRadioButton(String name) {
        Assert.notNull("name", name);
        Iterator iterator = this.getRadioButtonsByName(name).iterator();
        while (iterator.hasNext()) {
            HtmlRadioButtonInput input = (HtmlRadioButtonInput)iterator.next();
            if (!input.isChecked()) continue;
            return input;
        }
        return null;
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getActionAttribute() {
        return this.getAttributeValue("action");
    }

    public final void setActionAttribute(String action) {
        this.getElement().setAttribute("action", action);
    }

    public final String getMethodAttribute() {
        return this.getAttributeValue("method");
    }

    public final void setMethodAttribute(String method) {
        Assert.notNull("method", method);
        this.getElement().setAttribute("method", method);
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getEnctypeAttribute() {
        return this.getAttributeValue("enctype");
    }

    public final void setEnctypeAttribute(String encoding) {
        Assert.notNull("encoding", encoding);
        this.getElement().setAttribute("enctype", encoding);
    }

    public final String getOnSubmitAttribute() {
        return this.getAttributeValue("onsubmit");
    }

    public final String getOnResetAttribute() {
        return this.getAttributeValue("onreset");
    }

    public final String getAcceptAttribute() {
        return this.getAttributeValue("accept");
    }

    public final String getAcceptCharsetAttribute() {
        return this.getAttributeValue("accept-charset");
    }

    public final String getTargetAttribute() {
        return this.getAttributeValue("target");
    }

    public final void setTargetAttribute(String target) {
        Assert.notNull("target", target);
        this.getElement().setAttribute("target", target);
    }
}

