/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.w3c.dom.Element;

public class HtmlFrame
extends HtmlElement
implements WebWindow {
    private Page enclosedPage_;

    HtmlFrame(HtmlPage page, Element xmlElement) {
        super(page, xmlElement);
        WebClient webClient = page.getWebClient();
        webClient.registerWebWindow(this);
        String source = this.getSrcAttribute();
        try {
            URL url = page.getFullyQualifiedUrl(source);
            this.setEnclosedPage(webClient.getPage(this, url, SubmitMethod.GET, Collections.EMPTY_LIST, false));
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)("Unable to create url from [" + source + "]"), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((Object)("Error when loading from url [" + source + "]"), (Throwable)e);
        }
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLongDescAttribute() {
        return this.getAttributeValue("longdesc");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getFrameBorderAttribute() {
        return this.getAttributeValue("frameborder");
    }

    public final String getMarginWidthAttribute() {
        return this.getAttributeValue("marginwidth");
    }

    public final String getMarginHeightAttribute() {
        return this.getAttributeValue("marginheight");
    }

    public final String getNoResizeAttribute() {
        return this.getAttributeValue("noresize");
    }

    public final String getScrollingAttribute() {
        return this.getAttributeValue("scrolling");
    }

    public String getName() {
        return this.getNameAttribute();
    }

    public Page getEnclosedPage() {
        return this.enclosedPage_;
    }

    public void setEnclosedPage(Page page) {
        this.enclosedPage_ = page;
    }

    public WebClient getWebClient() {
        return this.getPage().getWebClient();
    }
}

