/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import org.w3c.dom.Element;

public class HtmlInput
extends HtmlElement
implements SubmittableElement {
    private final String originalValue_;
    private final boolean initialCheckedState_;
    private final String initialValue_;
    private boolean wasPositionSpecified_ = false;
    private boolean processingClick_ = false;
    private int xPosition_;
    private int yPosition_;

    HtmlInput(HtmlPage page, Element element) {
        super(page, element);
        this.originalValue_ = element.getAttribute("value");
        this.initialCheckedState_ = this.isAttributeDefined("checked");
        this.initialValue_ = this.getValueAttribute();
    }

    public void setValueAttribute(String newValue) {
        Assert.notNull("newValue", newValue);
        this.getElement().setAttribute("value", newValue);
        String onChange = this.getOnChangeAttribute();
        if (onChange.length() != 0) {
            this.getPage().executeJavaScriptIfPossible(onChange, "onChange handler", true, this);
        }
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        if (this.getTypeAttribute().equals("image")) {
            String name = this.getNameAttribute();
            if (this.wasPositionSpecified_) {
                return new KeyValuePair[]{new KeyValuePair(name + ".x", String.valueOf(this.xPosition_)), new KeyValuePair(name + ".y", String.valueOf(this.yPosition_))};
            }
        }
        return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public Page click() throws IOException {
        String type = this.getTypeAttribute();
        if (type.equals("file") || type.equals("hidden") || type.equals("password") || type.equals("text")) {
            return this.getPage();
        }
        if (type.equals("image") && !this.processingClick_) {
            this.wasPositionSpecified_ = false;
        }
        if (this.isDisabled()) {
            return this.getPage();
        }
        String onClick = this.getOnClickAttribute();
        HtmlPage page = this.getPage();
        if (onClick.length() == 0 || !page.getWebClient().isJavaScriptEnabled()) {
            return this.doClickAction();
        }
        ScriptResult scriptResult = page.executeJavaScriptIfPossible(onClick, "onClick handler for " + this.getClass().getName(), true, this);
        scriptResult.getJavaScriptResult();
        return this.doClickAction();
    }

    protected Page doClickAction() throws IOException {
        String type = this.getTypeAttribute().toLowerCase();
        if (type.equals("image") || type.equals("submit")) {
            return this.getEnclosingFormOrDie().submit(this);
        }
        if (type.equals("reset")) {
            return this.getEnclosingFormOrDie().reset();
        }
        return this.getPage();
    }

    public String asText() {
        return this.getValueAttribute();
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getValueAttribute() {
        String value = this.getAttributeValue("value");
        if (value == HtmlElement.ATTRIBUTE_NOT_DEFINED && this.getTypeAttribute().equals("checkbox")) {
            value = "on";
        }
        return value;
    }

    public final String getCheckedAttribute() {
        return this.getAttributeValue("checked");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeValue("readonly");
    }

    public final String getSizeAttribute() {
        return this.getAttributeValue("size");
    }

    public final String getMaxLengthAttribute() {
        return this.getAttributeValue("maxlength");
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final String getAltAttribute() {
        return this.getAttributeValue("alt");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeValue("usemap");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeValue("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }

    public final String getAcceptAttribute() {
        return this.getAttributeValue("accept");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public void reset() {
        String type = this.getTypeAttribute();
        if (type.equals("checkbox")) {
            this.setChecked(this.initialCheckedState_);
        } else if (type.equals("hidden") || type.equals("password") || type.equals("text")) {
            this.setValueAttribute(this.initialValue_);
        } else if (type.equals("radio")) {
            if (this.initialCheckedState_) {
                this.getElement().setAttribute("checked", "checked");
            } else {
                this.getElement().removeAttribute("checked");
            }
        }
    }

    public void setChecked(boolean isChecked) {
        String type = this.getTypeAttribute();
        if (type.equals("checkbox")) {
            this.setCheckedCheckBox(isChecked);
        } else if (type.equals("radio")) {
            this.setCheckedRadio(isChecked);
        }
    }

    private void setCheckedCheckBox(boolean isChecked) {
        if (isChecked) {
            this.getElement().setAttribute("checked", "checked");
        } else {
            this.getElement().removeAttribute("checked");
        }
    }

    private final void setCheckedRadio(boolean isChecked) {
        HtmlForm form = this.getEnclosingForm();
        if (isChecked) {
            try {
                form.setCheckedRadioButton(this.getNameAttribute(), this.getValueAttribute());
            }
            catch (ElementNotFoundException e) {
                throw new IllegalStateException("Can't find this element when going up to the form and back down.");
            }
        } else {
            this.getElement().removeAttribute("checked");
        }
    }

    public boolean isChecked() {
        return this.isAttributeDefined("checked");
    }

    public Page click(int x, int y) throws IOException, ElementNotFoundException {
        this.wasPositionSpecified_ = true;
        this.xPosition_ = x;
        this.yPosition_ = y;
        this.processingClick_ = true;
        Page returnValue = this.click();
        this.processingClick_ = false;
        return returnValue;
    }

    public Page submit() throws IOException, ElementNotFoundException {
        return this.click();
    }
}

