/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlElementCreator;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import org.w3c.dom.Element;

class HtmlInputElementCreator
extends HtmlElementCreator {
    HtmlInputElementCreator() {
    }

    HtmlElement create(HtmlPage page, Element xmlElement) {
        if (!page.getTagName(xmlElement).equals("input")) {
            throw new IllegalArgumentException("tagName is not 'input': " + page.getTagName(xmlElement));
        }
        String type = xmlElement.getAttribute("TYPE").toLowerCase();
        if (type.length() == 0) {
            return new HtmlTextInput(page, xmlElement);
        }
        if (type.equals("submit")) {
            return new HtmlSubmitInput(page, xmlElement);
        }
        if (type.equals("checkbox")) {
            return new HtmlCheckBoxInput(page, xmlElement);
        }
        if (type.equals("radio")) {
            return new HtmlRadioButtonInput(page, xmlElement);
        }
        if (type.equals("text")) {
            return new HtmlTextInput(page, xmlElement);
        }
        if (type.equals("hidden")) {
            return new HtmlHiddenInput(page, xmlElement);
        }
        if (type.equals("password")) {
            return new HtmlPasswordInput(page, xmlElement);
        }
        if (type.equals("image")) {
            return new HtmlImageInput(page, xmlElement);
        }
        if (type.equals("reset")) {
            return new HtmlResetInput(page, xmlElement);
        }
        if (type.equals("button")) {
            return new HtmlButtonInput(page, xmlElement);
        }
        if (type.equals("file")) {
            return new HtmlFileInput(page, xmlElement);
        }
        throw new IllegalStateException("Unexpected type [" + type + "]");
    }
}

