/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HtmlSelect
extends HtmlElement
implements SubmittableElement {
    private String[] fakeSelectedValues_;

    HtmlSelect(HtmlPage page, Element element) {
        super(page, element);
    }

    public List getSelectedOptions() {
        List allOptions = this.getAllOptions();
        ArrayList<HtmlOption> selectedOptions = new ArrayList<HtmlOption>(allOptions.size());
        Iterator iterator = allOptions.iterator();
        while (iterator.hasNext()) {
            HtmlOption option = (HtmlOption)iterator.next();
            if (!option.isSelected()) continue;
            selectedOptions.add(option);
        }
        return Collections.unmodifiableList(selectedOptions);
    }

    public List getAllOptions() {
        NodeList nodeList = this.getElement().getElementsByTagName("option");
        int nodeCount = nodeList.getLength();
        ArrayList<HtmlElement> allOptions = new ArrayList<HtmlElement>(nodeCount);
        HtmlPage page = this.getPage();
        int i = 0;
        while (i < nodeCount) {
            allOptions.add(page.getHtmlElement((Element)nodeList.item(i)));
            ++i;
        }
        return Collections.unmodifiableList(allOptions);
    }

    public Page setSelectedAttribute(String optionValue, boolean isSelected) {
        try {
            this.getOptionByValue(optionValue);
        }
        catch (ElementNotFoundException e) {
            throw new IllegalArgumentException("optionValue was not contained in the document: " + optionValue);
        }
        if (this.isMultipleSelectEnabled()) {
            List elements = this.getXmlElementsByAttribute("option", "value", optionValue);
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                this.setSelected((Element)iterator.next(), isSelected);
            }
        } else {
            Iterator iterator = this.getAllOptions().iterator();
            while (iterator.hasNext()) {
                HtmlOption option = (HtmlOption)iterator.next();
                this.setSelected(option.getElement(), option.getValueAttribute().equals(optionValue) && isSelected);
            }
        }
        HtmlPage page = this.getPage();
        String onChange = this.getOnChangeAttribute();
        if (onChange.length() != 0 && page.getWebClient().isJavaScriptEnabled()) {
            ScriptResult scriptResult = page.executeJavaScriptIfPossible(onChange, "onChange handler", true, this);
            return scriptResult.getNewPage();
        }
        return page;
    }

    public void fakeSelectedAttribute(String optionValue) {
        Assert.notNull("optionValue", optionValue);
        this.fakeSelectedAttribute(new String[]{optionValue});
    }

    public void fakeSelectedAttribute(String[] optionValues) {
        Assert.notNull("optionValues", optionValues);
        this.fakeSelectedValues_ = optionValues;
    }

    private void setSelected(Element element, boolean isSelected) {
        if (isSelected) {
            element.setAttribute("selected", "selected");
        } else {
            element.removeAttribute("selected");
        }
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        KeyValuePair[] pairs;
        String name = this.getNameAttribute();
        if (this.fakeSelectedValues_ == null) {
            List selectedOptions = this.getSelectedOptions();
            int optionCount = selectedOptions.size();
            pairs = new KeyValuePair[optionCount];
            int i = 0;
            while (i < optionCount) {
                HtmlOption option = (HtmlOption)selectedOptions.get(i);
                pairs[i] = new KeyValuePair(name, option.getValueAttribute());
                ++i;
            }
        } else {
            pairs = new KeyValuePair[this.fakeSelectedValues_.length];
            int i = 0;
            while (i < pairs.length) {
                pairs[i] = new KeyValuePair(name, this.fakeSelectedValues_[i]);
                ++i;
            }
        }
        return pairs;
    }

    public void reset() {
        Iterator iterator = this.getAllOptions().iterator();
        while (iterator.hasNext()) {
            HtmlOption option = (HtmlOption)iterator.next();
            option.reset();
        }
    }

    public boolean isMultipleSelectEnabled() {
        return this.getAttributeValue("multiple") != HtmlElement.ATTRIBUTE_NOT_DEFINED;
    }

    public HtmlOption getOptionByValue(String value) throws ElementNotFoundException {
        Assert.notNull("value", value);
        return (HtmlOption)this.getOneHtmlElementByAttribute("option", "value", value);
    }

    public String asText() {
        List options = this.isMultipleSelectEnabled() ? this.getAllOptions() : this.getSelectedOptions();
        boolean isFirstTimeThrough = true;
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = options.iterator();
        while (iterator.hasNext()) {
            if (isFirstTimeThrough) {
                isFirstTimeThrough = false;
            } else {
                buffer.append("\n");
            }
            HtmlOption currentOption = (HtmlOption)iterator.next();
            buffer.append(currentOption.asText());
        }
        return buffer.toString();
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getSizeAttribute() {
        return this.getAttributeValue("size");
    }

    public final String getMultipleAttribute() {
        return this.getAttributeValue("multiple");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }
}

