/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.html.HtmlCaption;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlTable
extends HtmlElement {
    private List tableRows_;

    HtmlTable(HtmlPage page, Element element) {
        super(page, element);
    }

    public final HtmlTableCell getCellAt(int row, int column) {
        List tableRows = this.getRows();
        Iterator rowIterator = tableRows.iterator();
        while (rowIterator.hasNext()) {
            List tableCells = ((HtmlTableRow)rowIterator.next()).getCells();
            Iterator cellIterator = tableCells.iterator();
            while (cellIterator.hasNext()) {
                HtmlTableCell cell = (HtmlTableCell)cellIterator.next();
                if (!cell.matchesPosition(row, column)) continue;
                return cell;
            }
        }
        return null;
    }

    public final synchronized List getRows() {
        if (this.tableRows_ != null) {
            return this.tableRows_;
        }
        ArrayList<HtmlTableRow> list = new ArrayList<HtmlTableRow>();
        NodeList nodeList = this.getElement().getChildNodes();
        int nodeCount = nodeList.getLength();
        HtmlPage page = this.getPage();
        int rowIndex = 0;
        int i = 0;
        while (i < nodeCount) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                String tagName = this.getTagName(element);
                if (tagName.equals("tr")) {
                    list.add(new HtmlTableRow(page, element, rowIndex));
                    ++rowIndex;
                } else if (tagName.equals("thead") || tagName.equals("tbody") || tagName.equals("tfoot")) {
                    NodeList subList = node.getChildNodes();
                    int subListCount = subList.getLength();
                    int subListIndex = 0;
                    while (subListIndex < subListCount) {
                        Element subElement;
                        Node subNode = subList.item(subListIndex);
                        if (subNode instanceof Element && this.getTagName(subElement = (Element)subNode).equals("tr")) {
                            list.add(new HtmlTableRow(page, subElement, rowIndex));
                            ++rowIndex;
                        }
                        ++subListIndex;
                    }
                }
            }
            ++i;
        }
        this.tableRows_ = Collections.unmodifiableList(list);
        return this.tableRows_;
    }

    public final int getRowCount() {
        return this.getRows().size();
    }

    public final HtmlTableRow getRowById(String id) throws ElementNotFoundException {
        Assert.notNull("id", id);
        this.assertNotEmpty("id", id);
        Iterator iterator = this.getRows().iterator();
        while (iterator.hasNext()) {
            HtmlTableRow row = (HtmlTableRow)iterator.next();
            if (!row.getIdAttribute().equals(id)) continue;
            return row;
        }
        throw new ElementNotFoundException("tr", "id", id);
    }

    public String getCaptionText() {
        Iterator iterator = this.getChildElements().iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlCaption)) continue;
            return element.asText();
        }
        return null;
    }

    public HtmlTableHeader getHeader() {
        Iterator iterator = this.getChildElements().iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlTableHeader)) continue;
            return (HtmlTableHeader)element;
        }
        return null;
    }

    public HtmlTableFooter getFooter() {
        Iterator iterator = this.getChildElements().iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlTableFooter)) continue;
            return (HtmlTableFooter)element;
        }
        return null;
    }

    public List getBodies() {
        ArrayList<HtmlElement> bodies = new ArrayList<HtmlElement>();
        Iterator iterator = this.getChildElements().iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            if (!(element instanceof HtmlTableBody)) continue;
            bodies.add(element);
        }
        return bodies;
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getSummaryAttribute() {
        return this.getAttributeValue("summary");
    }

    public final String getWidthAttribute() {
        return this.getAttributeValue("width");
    }

    public final String getBorderAttribute() {
        return this.getAttributeValue("border");
    }

    public final String getFrameAttribute() {
        return this.getAttributeValue("frame");
    }

    public final String getRulesAttribute() {
        return this.getAttributeValue("rules");
    }

    public final String getCellSpacingAttribute() {
        return this.getAttributeValue("cellspacing");
    }

    public final String getCellPaddingAttribute() {
        return this.getAttributeValue("cellpadding");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeValue("bgcolor");
    }
}

