/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeaderCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlTableRow
extends HtmlElement {
    private final int row_;
    private List tableCells_;

    HtmlTableRow(HtmlPage page, Element element, int row) {
        super(page, element);
        this.row_ = row;
    }

    public int getRow() {
        return this.row_;
    }

    public List getCells() {
        if (this.tableCells_ != null) {
            return this.tableCells_;
        }
        ArrayList<HtmlTableCell> list = new ArrayList<HtmlTableCell>();
        NodeList nodeList = this.getElement().getChildNodes();
        int nodeCount = nodeList.getLength();
        HtmlPage page = this.getPage();
        int rowIndex = this.getRow();
        int columnIndex = 0;
        int i = 0;
        while (i < nodeCount) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                String tagName = this.getTagName(element);
                if (tagName.equals("td")) {
                    list.add(new HtmlTableDataCell(page, element, rowIndex, columnIndex++));
                } else if (tagName.equals("th")) {
                    list.add(new HtmlTableHeaderCell(page, element, rowIndex, columnIndex++));
                }
            }
            ++i;
        }
        this.tableCells_ = Collections.unmodifiableList(list);
        return this.tableCells_;
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public final String getCharAttribute() {
        return this.getAttributeValue("char");
    }

    public final String getCharoffAttribute() {
        return this.getAttributeValue("charoff");
    }

    public final String getValignAttribute() {
        return this.getAttributeValue("valign");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeValue("bgcolor");
    }
}

