/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public class FormElementsArray
extends SimpleScriptable {
    private HtmlForm htmlForm_;

    public final void jsConstructor() {
    }

    public void initialize(HtmlForm form) {
        Assert.notNull("form", form);
        this.htmlForm_ = form;
    }

    public Object get(int index, Scriptable start) {
        HtmlForm htmlForm = ((FormElementsArray)start).htmlForm_;
        List formElements = this.getHtmlElementsInForm(htmlForm);
        try {
            return this.getScriptableFor((HtmlElement)formElements.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            return Scriptable.NOT_FOUND;
        }
    }

    public Object get(String name, Scriptable start) {
        HtmlForm htmlForm = this.htmlForm_;
        if (htmlForm == null) {
            return super.get(name, start);
        }
        List elementList = this.getHtmlElementsInForm(htmlForm);
        Iterator iterator = elementList.iterator();
        while (iterator.hasNext()) {
            HtmlElement htmlElement = (HtmlElement)iterator.next();
            if (!htmlElement.getAttributeValue("name").equals(name)) continue;
            if (htmlElement instanceof HtmlInput) {
                ArrayList<SimpleScriptable> collectedRadioButtons = new ArrayList<SimpleScriptable>(elementList.size());
                collectedRadioButtons.add(this.getScriptableFor(htmlElement));
                while (iterator.hasNext()) {
                    htmlElement = (HtmlElement)iterator.next();
                    if (!(htmlElement instanceof HtmlInput) || !((HtmlInput)htmlElement).getNameAttribute().equals(name)) continue;
                    collectedRadioButtons.add(this.getScriptableFor(htmlElement));
                }
                switch (collectedRadioButtons.size()) {
                    case 0: {
                        return Scriptable.NOT_FOUND;
                    }
                    case 1: {
                        return collectedRadioButtons.get(0);
                    }
                }
                return new NativeArray(collectedRadioButtons.toArray());
            }
            return this.getScriptableFor(htmlElement);
        }
        return super.get(name, start);
    }

    public int jsGet_length() {
        return this.getHtmlElementsInForm(this.htmlForm_).size();
    }

    private List getHtmlElementsInForm(HtmlForm htmlForm) {
        Assert.notNull("htmlForm", htmlForm);
        return htmlForm.getHtmlElementsByTagNames(Arrays.asList("input", "button", "select", "textarea"));
    }
}

