/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ScriptEngine;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.StrictErrorReporter;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class JavaScriptEngine
extends ScriptEngine {
    private final Map pageInfos_ = new WeakHashMap(89);
    static /* synthetic */ Class class$com$gargoylesoftware$htmlunit$javascript$DocumentAllArray;
    static /* synthetic */ Class class$com$gargoylesoftware$htmlunit$javascript$FormElementsArray;

    public JavaScriptEngine(WebClient webClient) {
        super(webClient);
    }

    private synchronized PageInfo getPageInfo(HtmlPage htmlPage) {
        Assert.notNull("htmlPage", htmlPage);
        PageInfo existingPageInfo = (PageInfo)this.pageInfos_.get(htmlPage);
        if (existingPageInfo != null) {
            return existingPageInfo;
        }
        try {
            PageInfo newPageInfo = new PageInfo(this);
            newPageInfo.context_ = Context.enter();
            newPageInfo.getContext().setErrorReporter((ErrorReporter)new StrictErrorReporter(this.getScriptEngineLog()));
            Scriptable parentScope = newPageInfo.getContext().initStandardObjects(null);
            String[] hostClassNames = new String[]{"HTMLElement", "Window", "Document", "Form", "Input", "Navigator", "Screen", "History", "Location", "Button", "Select", "Textarea", "Style", "Option", "Anchor", "Image"};
            int i = 0;
            while (i < hostClassNames.length) {
                String className = "com.gargoylesoftware.htmlunit.javascript.host." + hostClassNames[i];
                try {
                    ScriptableObject.defineClass((Scriptable)parentScope, Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(className);
                }
                ++i;
            }
            ScriptableObject.defineClass((Scriptable)parentScope, (Class)(class$com$gargoylesoftware$htmlunit$javascript$DocumentAllArray == null ? (class$com$gargoylesoftware$htmlunit$javascript$DocumentAllArray = JavaScriptEngine.class$("com.gargoylesoftware.htmlunit.javascript.DocumentAllArray")) : class$com$gargoylesoftware$htmlunit$javascript$DocumentAllArray));
            ScriptableObject.defineClass((Scriptable)parentScope, (Class)(class$com$gargoylesoftware$htmlunit$javascript$FormElementsArray == null ? (class$com$gargoylesoftware$htmlunit$javascript$FormElementsArray = JavaScriptEngine.class$("com.gargoylesoftware.htmlunit.javascript.FormElementsArray")) : class$com$gargoylesoftware$htmlunit$javascript$FormElementsArray));
            Window window = (Window)newPageInfo.getContext().newObject(parentScope, "Window", new Object[0]);
            newPageInfo.scope_ = (Scriptable)window;
            newPageInfo.getScope().setParentScope(parentScope);
            window.setPageInfo(newPageInfo);
            window.initialize(htmlPage);
            this.pageInfos_.put(htmlPage, newPageInfo);
            return newPageInfo;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    private Scriptable getScope(PageInfo pageInfo, HtmlElement htmlElementScope) {
        Object scope;
        if (htmlElementScope == null) {
            scope = pageInfo.getScope();
        } else {
            scope = (Scriptable)htmlElementScope.getScriptObject();
            if (scope == null) {
                scope = ((SimpleScriptable)pageInfo.getScope()).getScriptableFor(htmlElementScope);
            }
            scope.setParentScope(pageInfo.getScope());
        }
        return scope;
    }

    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName, HtmlElement htmlElementScope) {
        Assert.notNull("sourceCode", sourceCode);
        sourceCode = sourceCode.trim();
        if (sourceCode.startsWith("<!--")) {
            int startIndex = 4;
            int endIndex = sourceCode.endsWith("-->") ? sourceCode.length() - 3 : sourceCode.length();
            char eachChar = sourceCode.charAt(startIndex);
            while (startIndex <= endIndex && eachChar != '\n' && eachChar != '\r') {
                eachChar = sourceCode.charAt(++startIndex);
            }
            sourceCode = sourceCode.substring(startIndex, endIndex);
        }
        PageInfo pageInfo = this.getPageInfo(htmlPage);
        boolean lineNumber = true;
        Object securityDomain = null;
        Scriptable scope = this.getScope(pageInfo, htmlElementScope);
        try {
            Object result = pageInfo.getContext().evaluateString(scope, sourceCode, sourceName, 1, securityDomain);
            return result;
        }
        catch (JavaScriptException e) {
            throw new ScriptException(e, sourceCode);
        }
        catch (Throwable t) {
            throw new ScriptException(t, sourceCode);
        }
    }

    public Object callFunction(HtmlPage htmlPage, Object javaScriptFunction, Object thisObject, Object[] args, HtmlElement htmlElementScope) {
        PageInfo pageInfo = this.getPageInfo(htmlPage);
        Scriptable scope = this.getScope(pageInfo, htmlElementScope);
        try {
            Object result = ((Function)javaScriptFunction).call(pageInfo.getContext(), scope, (Scriptable)thisObject, args);
            return result;
        }
        catch (JavaScriptException e) {
            throw new ScriptException(e, this.toString(htmlPage, javaScriptFunction));
        }
        catch (Throwable t) {
            throw new ScriptException(t, this.toString(htmlPage, javaScriptFunction));
        }
    }

    public String toString(HtmlPage htmlPage, Object javaScriptObject) {
        PageInfo pageInfo = this.getPageInfo(htmlPage);
        pageInfo.getContext();
        String result = Context.toString((Object)javaScriptObject);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class PageInfo {
        private final JavaScriptEngine engine_;
        private Context context_;
        private Scriptable scope_;

        public PageInfo(JavaScriptEngine engine) {
            this.engine_ = engine;
        }

        public Context getContext() {
            return this.context_;
        }

        public Scriptable getScope() {
            return this.scope_;
        }

        public JavaScriptEngine getJavaScriptEngine() {
            return this.engine_;
        }
    }
}

