/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class SimpleScriptable
extends ScriptableObject {
    private static final Map PROPERTY_MAPS = Collections.synchronizedMap(new HashMap(89));
    private static Map HtmlJavaScriptMap_ = null;
    private JavaScriptEngine.PageInfo pageInfo_;
    private HtmlElement htmlElement_;

    public static synchronized Map getHtmlJavaScriptMapping() {
        if (HtmlJavaScriptMap_ != null) {
            return HtmlJavaScriptMap_;
        }
        String[][] mapping = new String[][]{{"HtmlAnchor", "Anchor"}, {"HtmlButton", "Button"}, {"HtmlInput", "Input"}, {"HtmlCheckBoxInput", "Input"}, {"HtmlFileInput", "Input"}, {"HtmlForm", "Form"}, {"HtmlHiddenInput", "Input"}, {"HtmlImage", "Image"}, {"HtmlInlineFrame", "Window"}, {"HtmlOption", "Option"}, {"HtmlPasswordInput", "Input"}, {"HtmlRadioButtonInput", "Input"}, {"HtmlResetInput", "Input"}, {"HtmlSelect", "Select"}, {"HtmlSubmitInput", "Input"}, {"HtmlTextInput", "Input"}, {"HtmlTextArea", "Textarea"}, {"HtmlElement", "HTMLElement"}};
        HashMap map = new HashMap();
        int i = 0;
        while (i < mapping.length) {
            String htmlClassName = mapping[i][0];
            String javaScriptClassName = mapping[i][1];
            try {
                Class<?> htmlClass = Class.forName("com.gargoylesoftware.htmlunit.html." + htmlClassName);
                Class.forName("com.gargoylesoftware.htmlunit.javascript.host." + javaScriptClassName);
                map.put(htmlClass, javaScriptClassName);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            ++i;
        }
        HtmlJavaScriptMap_ = Collections.unmodifiableMap(map);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getPropertyMap() {
        Map map = PROPERTY_MAPS;
        synchronized (map) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            String className = clazz.getName();
            Map localPropertyMap = (Map)PROPERTY_MAPS.get(className);
            if (localPropertyMap == null && this.htmlElement_ != null) {
                try {
                    localPropertyMap = this.createLocalPropertyMap();
                }
                catch (Exception e) {
                    throw new ScriptException(e);
                }
                PROPERTY_MAPS.put(className, localPropertyMap);
            }
            return localPropertyMap;
        }
    }

    private JavaScriptConfiguration getJavaScriptConfiguration() {
        BrowserVersion browserVersion = this.getHtmlElementOrDie().getPage().getWebClient().getBrowserVersion();
        return JavaScriptConfiguration.getInstance(browserVersion);
    }

    private Map createLocalPropertyMap() throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        JavaScriptConfiguration configuration = this.getJavaScriptConfiguration();
        HashMap localPropertyMap = new HashMap(89);
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            int state;
            String propertyName;
            String methodName = methods[i].getName();
            if (methodName.startsWith("jsGet_") && methods[i].getParameterTypes().length == 0) {
                propertyName = methodName.substring(6);
                state = configuration.getReadablePropertyNameState(clazz, propertyName);
                if (state == 1) {
                    this.getPropertyInfo(localPropertyMap, propertyName).getter_ = methods[i];
                } else if (state == 3) {
                    this.getLog().trace((Object)("Getter for [" + propertyName + "] not found in configuration"));
                }
            } else if (methodName.startsWith("jsSet_") && methods[i].getParameterTypes().length == 1) {
                propertyName = methodName.substring(6);
                state = configuration.getWritablePropertyNameState(clazz, propertyName);
                if (state == 1) {
                    this.getPropertyInfo(localPropertyMap, propertyName).setter_ = methods[i];
                } else if (state == 3) {
                    this.getLog().trace((Object)("Setter for [" + propertyName + "] not found in configuration"));
                }
            } else if (methodName.startsWith("jsFunction_")) {
                String functionName = methodName.substring("jsFunction_".length());
                state = configuration.getFunctionNameState(clazz, functionName);
                if (state == 1) {
                    FunctionObject functionObject = new FunctionObject(functionName, (Member)methods[i], (Scriptable)this);
                    this.getPropertyInfo(localPropertyMap, functionName).function_ = functionObject;
                } else if (state == 3) {
                    this.getLog().trace((Object)("Function [" + functionName + "] not found in configuration"));
                }
            }
            ++i;
        }
        return localPropertyMap;
    }

    private PropertyInfo getPropertyInfo(Map localPropertyMap, String name) {
        PropertyInfo info = (PropertyInfo)localPropertyMap.get(name);
        if (info == null) {
            info = new PropertyInfo();
            localPropertyMap.put(name, info);
        }
        return info;
    }

    public String getClassName() {
        String javaClassName = ((Object)((Object)this)).getClass().getName();
        int index = javaClassName.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalStateException("No dot in classname: " + javaClassName);
        }
        return javaClassName.substring(index + 1);
    }

    public final void setPageInfo(JavaScriptEngine.PageInfo pageInfo) {
        Assert.notNull("pageInfo", pageInfo);
        this.pageInfo_ = pageInfo;
    }

    public JavaScriptEngine getJavaScriptEngine() {
        return this.getPageInfo().getJavaScriptEngine();
    }

    public SimpleScriptable makeJavaScriptObject(String className) {
        JavaScriptEngine.PageInfo pageInfo = this.getPageInfo();
        try {
            SimpleScriptable newObject = (SimpleScriptable)pageInfo.getContext().newObject(pageInfo.getScope(), className, new Object[0]);
            newObject.setPageInfo(pageInfo);
            return newObject;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public final HtmlElement getHtmlElementOrDie() throws IllegalStateException {
        if (this.htmlElement_ == null) {
            throw new IllegalStateException("HtmlElement has not been set for this SimpleScriptable: " + ((Object)((Object)this)).getClass().getName());
        }
        return this.htmlElement_;
    }

    public final HtmlElement getHtmlElementOrNull() {
        return this.htmlElement_;
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        Assert.notNull("htmlElement", htmlElement);
        this.htmlElement_ = htmlElement;
        this.htmlElement_.setScriptObject((Object)this);
    }

    public Object get(String name, Scriptable start) {
        Object result;
        if (this.htmlElement_ == null) {
            return super.get(name, start);
        }
        JavaScriptConfiguration configuration = this.getJavaScriptConfiguration();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        PropertyInfo info = (PropertyInfo)this.getPropertyMap().get(name);
        int propertyNameState = configuration.getReadablePropertyNameState(clazz, name);
        int functionNameState = configuration.getFunctionNameState(clazz, name);
        if (propertyNameState == 1) {
            if (functionNameState == 1) {
                throw new IllegalStateException("Name is both a property and a function: name=[" + name + "] class=[" + clazz.getName() + "]");
            }
        }
        if (propertyNameState == 1) {
            if (info == null || info.getter_ == null) {
                this.getLog().debug((Object)("Getter not implemented for property [" + name + "]"));
                result = Scriptable.NOT_FOUND;
            } else {
                try {
                    result = info.getter_.invoke((Object)this, new Object[0]);
                }
                catch (Exception e) {
                    throw new ScriptException(e);
                }
            }
        } else if (functionNameState == 1) {
            if (info == null || info.function_ == null) {
                this.getLog().debug((Object)("Function not implemented [" + name + "]"));
                result = Scriptable.NOT_FOUND;
            } else {
                result = info.function_;
            }
        } else {
            result = super.get(name, start);
        }
        return result;
    }

    public void put(String name, Scriptable start, Object newValue) {
        if (this.htmlElement_ == null) {
            super.put(name, start, newValue);
            return;
        }
        JavaScriptConfiguration configuration = this.getJavaScriptConfiguration();
        int propertyNameState = configuration.getWritablePropertyNameState(((Object)((Object)this)).getClass(), name);
        PropertyInfo info = (PropertyInfo)this.getPropertyMap().get(name);
        if (propertyNameState == 1) {
            if (info == null || info.setter_ == null) {
                this.getLog().debug((Object)("Setter not implemented for property [" + name + "]"));
            } else {
                Class<?> parameterClass = info.setter_.getParameterTypes()[0];
                if (parameterClass == "".getClass()) {
                    newValue = newValue.toString();
                }
                try {
                    info.setter_.invoke((Object)this.findMatchingScriptable(start, info.setter_), newValue);
                }
                catch (InvocationTargetException e) {
                    throw new ScriptException(e.getTargetException());
                }
                catch (Exception e) {
                    throw new ScriptException(e);
                }
            }
        } else {
            super.put(name, start, newValue);
        }
    }

    private Scriptable findMatchingScriptable(Scriptable start, Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Scriptable scriptable = start;
        while (!declaringClass.isInstance(start)) {
            if ((scriptable = scriptable.getPrototype()) != null) continue;
            throw new IllegalStateException("Couldn't find a matching scriptable");
        }
        return scriptable;
    }

    protected final Log getLog() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    private JavaScriptEngine.PageInfo getPageInfo() {
        if (this.pageInfo_ == null) {
            throw new IllegalStateException("pageInfo_ has not been initialized!");
        }
        return this.pageInfo_;
    }

    public SimpleScriptable getScriptableFor(HtmlElement htmlElement) {
        Object scriptObject = htmlElement.getScriptObject();
        if (scriptObject != null) {
            return (SimpleScriptable)((Object)scriptObject);
        }
        String javaScriptClassName = (String)SimpleScriptable.getHtmlJavaScriptMapping().get(htmlElement.getClass());
        if (javaScriptClassName == null) {
            SimpleScriptable scriptable = this.makeJavaScriptObject("HTMLElement");
            scriptable.setHtmlElement(htmlElement);
            return scriptable;
        }
        SimpleScriptable scriptable = this.makeJavaScriptObject(javaScriptClassName);
        scriptable.setHtmlElement(htmlElement);
        return scriptable;
    }

    public static Object getObjectArg(int index, Object[] args, Object defaultValue) {
        if (index >= args.length) {
            return defaultValue;
        }
        return args[index];
    }

    public static String getStringArg(int index, Object[] args, String defaultValue) {
        Object object = SimpleScriptable.getObjectArg(index, args, defaultValue);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static boolean getBooleanArg(int index, Object[] args, boolean defaultValue) {
        Boolean defaultBoolean = defaultValue ? Boolean.TRUE : Boolean.FALSE;
        return (Boolean)SimpleScriptable.getObjectArg(index, args, defaultBoolean);
    }

    public static int getIntArg(int index, Object[] args, int defaultValue) {
        Object result = SimpleScriptable.getObjectArg(index, args, new Integer(defaultValue));
        if (result instanceof String) {
            return Integer.parseInt((String)result);
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        throw new IllegalStateException("Unexpected type for result: " + result.getClass().getName());
    }

    public Object getDefaultValue(Class hint) {
        return ((Object)((Object)this)).toString();
    }

    private class PropertyInfo {
        private Method getter_;
        private Method setter_;
        private FunctionObject function_;

        private PropertyInfo() {
        }
    }
}

