/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import org.apache.commons.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class StrictErrorReporter
implements ErrorReporter {
    private final Log log_;

    public StrictErrorReporter(Log log) {
        Assert.notNull("log", log);
        this.log_ = log;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.print("warning", message, sourceName, line, lineSource, lineOffset);
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.print("error", message, sourceName, line, lineSource, lineOffset);
        throw new EvaluatorException(message);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.print("runtimeError", message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }

    private void print(String prefix, String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.log_.debug((Object)(prefix + ": message=[" + message + "] sourceName=[" + sourceName + "] line=[" + line + "] lineSource=[" + lineSource + "] lineOffset=[" + lineOffset + "]"));
    }
}

