/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Style;
import org.apache.html.dom.HTMLDocumentImpl;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLElement
extends SimpleScriptable {
    private Style style_;

    public void jsConstructor() {
    }

    public Object jsGet_style() {
        this.getLog().debug((Object)("HTMLElement.jsGet_Style() style=[" + (Object)((Object)this.style_) + "]"));
        return this.style_;
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        super.setHtmlElement(htmlElement);
        this.style_ = (Style)this.makeJavaScriptObject("Style");
        this.style_.initialize(this);
    }

    public boolean jsGet_disabled() {
        this.getLog().warn((Object)"Getting the disabled attribute for non-submittable elements is not allowed according to the HTML specification.  Be aware that you are using a non-portable feature");
        return this.getHtmlElementOrDie().isAttributeDefined("disabled");
    }

    public void jsSet_disabled(boolean disabled) {
        this.getLog().warn((Object)"Setting the disabled attribute for non-submittable elements is not allowed according to the HTML specification.  Be aware that you are using a non-portable feature");
        Element xmlElement = this.getHtmlElementOrDie().getElement();
        if (disabled) {
            xmlElement.setAttribute("disabled", "disabled");
        } else {
            xmlElement.removeAttribute("disabled");
        }
    }

    public String jsGet_tagName() {
        return this.getHtmlElementOrDie().getTagName().toUpperCase();
    }

    public Object get(String name, Scriptable start) {
        String value;
        HtmlElement htmlElement;
        Object result = super.get(name, start);
        if (result == Scriptable.NOT_FOUND && (htmlElement = this.getHtmlElementOrNull()) != null && (value = htmlElement.getAttributeValue(name)).length() != 0) {
            result = value;
        }
        return result;
    }

    public Object jsFunction_appendChild(Object childObject) {
        Object appendedChild;
        if (childObject instanceof HTMLElement) {
            HtmlElement childHtmlElement = ((HTMLElement)((Object)childObject)).getHtmlElementOrDie();
            Element childXmlNode = childHtmlElement.getElement();
            HtmlElement parentElement = this.getHtmlElementOrDie();
            Element parentXmlNode = parentElement.getElement();
            appendedChild = parentXmlNode.appendChild(childXmlNode) == null ? null : childObject;
        } else {
            appendedChild = null;
        }
        return appendedChild;
    }

    public Object jsGet_parentNode() {
        HtmlElement htmlElement = this.getHtmlElementOrDie();
        Element xmlElement = htmlElement.getElement();
        Node parentXmlNode = xmlElement.getParentNode();
        if (parentXmlNode == null) {
            return null;
        }
        if (!(parentXmlNode instanceof Element)) {
            if (!(parentXmlNode instanceof HTMLDocumentImpl)) {
                throw new IllegalStateException("Parent XML node is not an Element.  Only Elements are currently supported.  Parent class: " + parentXmlNode.getClass());
            }
            return null;
        }
        Element parentXmlElement = (Element)parentXmlNode;
        HtmlElement parentHtmlElement = htmlElement.getPage().getHtmlElement(parentXmlElement);
        SimpleScriptable jsParentElement = this.getScriptableFor(parentHtmlElement);
        return jsParentElement;
    }
}

