/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2007 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.webui.jsf.example.table;

import java.io.Serializable;

import com.sun.webui.jsf.example.table.util.Dynamic;
import com.sun.webui.jsf.example.common.MessageUtil;
import com.sun.webui.jsf.example.index.IndexBackingBean;

import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableRowGroup;

/** Backing bean for dynamic group table examples.
 *
 * Note: To simplify the example, this bean is used only to create the table 
 * layout. The resulting table will use methods already defined in TableBean.
 *
 * Note that we must implement java.io.Serializable or
 * javax.faces.component.StateHolder in case client-side
 * state saving is used, or if server-side state saving is
 * used with a distributed system.
 */
public class DynamicGroupTableBean implements Serializable {
    private Dynamic dynamic = null; // Dynamic util.
    private Table table = null; // Table component.

    // Default constructor.
    public DynamicGroupTableBean() {
        dynamic = new Dynamic();
    }

    // Get Table component.
    public Table getTable() {
        if (table == null) {
            // Get table row group.
            TableRowGroup rowGroup1 = dynamic.getTableRowGroup("rowGroup1",
                "#{TableBean.groupB.names}",
                "#{TableBean.groupB.select.selectedState}",
                "Group Header");
            TableRowGroup rowGroup2 = dynamic.getTableRowGroup("rowGroup2",
                "#{TableBean.groupC.names}",
                "#{TableBean.groupC.select.selectedState}",
                "Group Header");

            // Set table row group properties.
            dynamic.setTableRowGroupChildren(rowGroup1, 
                "#{TableBean.groupB.select.selectedState}", 
                "#{TableBean.groupB.select.selected}",
                "#{TableBean.groupB.select.selectedValue}", null, true);
            dynamic.setTableRowGroupChildren(rowGroup2, 
                "#{TableBean.groupC.select.selectedState}", 
                "#{TableBean.groupC.select.selected}",
                "#{TableBean.groupC.select.selectedValue}", null, false);

            // Set select and row group toggle buttons.
            rowGroup1.setSelectMultipleToggleButton(true); 
            rowGroup2.setSelectMultipleToggleButton(true); 
            rowGroup1.setGroupToggleButton(true);
            rowGroup2.setGroupToggleButton(true);

            // Get table.
            table = dynamic.getTable("table1", null);
            table.getChildren().add(rowGroup1);
            table.getChildren().add(rowGroup2);

            // Add title facet.
            StaticText title = new StaticText();
            title.setText(MessageUtil.getMessage("table_dynamicGroupTitle"));
            table.getFacets().put(Table.TITLE_FACET, title);
        }
        return table;
    }

    // Set Table component. 
    //
    // @param table The Table component.
    public void setTable(Table table) {
        this.table = table;
    }
    
    // Action handler when navigating to the table index.
    public String showTableIndex() {
        reset();
        return TableBean.SHOW_TABLE_INDEX;
    }
    
    // Action handler when navigating to the main example index.
    public String showExampleIndex() {
        reset();
        return IndexBackingBean.INDEX_ACTION;
    }
    
    // Reset values so next visit starts fresh.
    private void reset() {
        table = null;
        dynamic = new Dynamic();
    }
}
