/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2007 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.webui.jsf.theme;

/**
 * <p> This class contains HTML template related theme constants.</p>
 */
public class ThemeTemplates {

    /**
     * A template file that contains HTML for the Button component.
     */
    public static final String BUTTON = "button";
    /**
     * A template file that contains HTML for the Table2 component.
     */
    public static final String TABLE2 = "table2";
    /**
     * A template file that contains HTML for the Table2RowGroup component.
     */
    public static final String TABLE2ROWGROUP = "table2RowGroup";
    /**
     * A template file that contains HTML for the ProgressBar component.
     */
    public static final String PROGRESSBAR = "progressBar";

    /**
     * This private constructor prevents this class from being instantiated
     * directly as its only purpose is to provide image constants.
     */
    private ThemeTemplates() {
        // do nothing
    }
}


