/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.OutputMessageRenderer;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageRenderer
extends HtmlBasicRenderer {
    private OutputMessageRenderer omRenderer = new OutputMessageRenderer();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (component instanceof UIOutput) {
            this.omRenderer.encodeBegin(context, component);
            return;
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (component instanceof UIOutput) {
            this.omRenderer.encodeChildren(context, component);
            return;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Iterator messageIter = null;
        FacesMessage curMessage = null;
        ResponseWriter writer = null;
        if (context == null || component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", new Object[0]));
        }
        if (component instanceof UIOutput) {
            this.omRenderer.encodeEnd(context, component);
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = ((UIMessage)component).getFor();
        if (clientId == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("'for' attribute cannot be null");
            }
            return;
        }
        messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            return;
        }
        curMessage = (FacesMessage)messageIter.next();
        String summary = null;
        String detail = null;
        String severityStyle = null;
        String severityStyleClass = null;
        boolean showSummary = ((UIMessage)component).isShowSummary();
        boolean showDetail = ((UIMessage)component).isShowDetail();
        summary = curMessage.getSummary();
        summary = null != summary ? summary : "";
        detail = curMessage.getDetail();
        String string = detail = null != detail ? detail : "";
        if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
            severityStyle = (String)component.getAttributes().get("infoStyle");
            severityStyleClass = (String)component.getAttributes().get("infoClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
            severityStyle = (String)component.getAttributes().get("warnStyle");
            severityStyleClass = (String)component.getAttributes().get("warnClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
            severityStyle = (String)component.getAttributes().get("errorStyle");
            severityStyleClass = (String)component.getAttributes().get("errorClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
            severityStyle = (String)component.getAttributes().get("fatalStyle");
            severityStyleClass = (String)component.getAttributes().get("fatalClass");
        }
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (style != null && severityStyle != null) {
            style = severityStyle;
        } else if (style == null && severityStyle != null) {
            style = severityStyle;
        }
        if (styleClass != null && severityStyleClass != null) {
            styleClass = severityStyleClass;
        } else if (styleClass == null && severityStyleClass != null) {
            styleClass = severityStyleClass;
        }
        boolean wroteSpan = false;
        boolean wroteTable = false;
        if (styleClass != null || style != null || this.shouldWriteIdAttribute(component) || RenderKitUtils.hasPassThruAttributes(component)) {
            writer.startElement("span", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            wroteSpan = true;
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            RenderKitUtils.renderPassThruAttributes(context, writer, component);
        }
        Object tooltip = component.getAttributes().get("tooltip");
        boolean isTooltip = false;
        if (tooltip instanceof Boolean) {
            isTooltip = (Boolean)tooltip;
        }
        boolean wroteTooltip = false;
        if (showSummary && showDetail && isTooltip) {
            String title;
            if (!wroteSpan) {
                writer.startElement("span", component);
            }
            if ((title = (String)component.getAttributes().get("title")) == null || title.length() == 0) {
                writer.writeAttribute("title", (Object)summary, "title");
            }
            writer.flush();
            writer.writeText((Object)"\t", null);
            wroteTooltip = true;
        } else if (wroteSpan) {
            writer.flush();
        }
        if (!wroteTooltip && showSummary) {
            writer.writeText((Object)"\t", null);
            writer.writeText((Object)summary, null);
            writer.writeText((Object)" ", null);
        }
        if (showDetail) {
            writer.writeText((Object)detail, null);
        }
        if (wroteSpan || wroteTooltip) {
            writer.endElement("span");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }
}

