/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;

final class HttpMethodSpec {
    private static final String comma = ",";
    private static final String emptyString = "";
    private static final String exclaimationPoint = "!";
    private static final char exclaimationPointChar = '!';
    private static Object[] methodKeys;
    private static int mapSize;
    private static HashMap methodHash;
    private static int allSet;
    private static HttpMethodSpec[] specArray;
    private static HttpMethodSpec[] exceptionSpecArray;
    private static HttpMethodSpec allSpec;
    private static ArrayList extensionMethods;
    HttpMethodSpec standardSpec;
    boolean exceptionList;
    int standardMap;
    BitSet extensionSet;
    String actions;

    static HttpMethodSpec getSpec(String actions) {
        HttpMethodSpec rvalue;
        if (actions == null || actions.equals(emptyString)) {
            rvalue = allSpec;
        } else {
            BitSet set = new BitSet();
            rvalue = HttpMethodSpec.getStandardSpec(actions, set);
            if (!set.isEmpty()) {
                rvalue = new HttpMethodSpec(rvalue, set);
            }
        }
        return rvalue;
    }

    static HttpMethodSpec getSpec(String[] methods) {
        HttpMethodSpec rvalue;
        if (methods == null || methods.length == 0) {
            rvalue = allSpec;
        } else {
            int map = 0;
            BitSet set = new BitSet();
            for (int i = 0; i < methods.length; ++i) {
                Integer bit = (Integer)methodHash.get(methods[i]);
                if (bit != null) {
                    map |= bit.intValue();
                    continue;
                }
                HttpMethodSpec.setExtensionBit(methods[i], set);
            }
            rvalue = set.isEmpty() ? specArray[map] : new HttpMethodSpec(specArray[map], set);
        }
        return rvalue;
    }

    public String toString() {
        return this.getActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getActions() {
        if (this.standardMap == 0 && this.extensionSet == null) {
            return null;
        }
        HttpMethodSpec httpMethodSpec = this;
        synchronized (httpMethodSpec) {
            if (this.actions != null) {
                return this.actions;
            }
            this.actions = this.standardSpec != null ? this.getExtensionActions(this.standardSpec.getActions(), this.standardMap, this.extensionSet) : this.getStandardActions(this.exceptionList, this.standardMap);
        }
        return this.actions;
    }

    public int hashCode() {
        return (this.exceptionList ? 1 : 0) + (this.standardMap << 1) + ((this.extensionSet == null ? 0 : this.extensionSet.hashCode()) << mapSize + 1);
    }

    public boolean equals(Object that) {
        boolean rvalue = false;
        if (that != null && that instanceof HttpMethodSpec) {
            rvalue = that == this ? true : this.hashCode() == ((HttpMethodSpec)that).hashCode();
        }
        return rvalue;
    }

    boolean implies(HttpMethodSpec that) {
        boolean rvalue;
        if (this.standardMap == 0 && this.extensionSet == null) {
            rvalue = true;
        } else if (that.standardMap == 0 && that.extensionSet == null) {
            rvalue = false;
        } else if (this.exceptionList && that.exceptionList) {
            boolean bl = rvalue = (this.standardMap & that.standardMap) == this.standardMap;
            if (rvalue && this.extensionSet != null) {
                if (that.extensionSet == null) {
                    rvalue = false;
                } else {
                    BitSet clone = (BitSet)that.extensionSet.clone();
                    clone.and(this.extensionSet);
                    rvalue = clone.equals(this.extensionSet);
                }
            }
        } else if (this.exceptionList == that.exceptionList) {
            boolean bl = rvalue = (this.standardMap & that.standardMap) == that.standardMap;
            if (rvalue && that.extensionSet != null) {
                if (this.extensionSet == null) {
                    rvalue = false;
                } else {
                    BitSet clone = (BitSet)that.extensionSet.clone();
                    clone.and(this.extensionSet);
                    rvalue = clone.equals(that.extensionSet);
                }
            }
        } else if (this.exceptionList) {
            boolean bl = rvalue = (this.standardMap & that.standardMap) == 0;
            if (rvalue && that.extensionSet != null) {
                rvalue = this.extensionSet == null ? true : !this.extensionSet.intersects(that.extensionSet);
            }
        } else {
            rvalue = false;
        }
        return rvalue;
    }

    private HttpMethodSpec(boolean isExceptionList, int map) {
        this.standardSpec = null;
        this.exceptionList = isExceptionList;
        this.standardMap = map;
        this.extensionSet = null;
        this.actions = null;
    }

    private HttpMethodSpec(HttpMethodSpec spec, BitSet set) {
        this.standardSpec = spec;
        this.exceptionList = spec.exceptionList;
        this.standardMap = spec.standardMap;
        this.extensionSet = set.isEmpty() ? null : set;
        this.actions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setExtensionBit(String method, BitSet set) {
        int bitPos;
        ArrayList arrayList = extensionMethods;
        synchronized (arrayList) {
            bitPos = extensionMethods.indexOf(method);
            if (bitPos < 0) {
                bitPos = extensionMethods.size();
                extensionMethods.add(method);
            }
        }
        set.set(bitPos);
    }

    private static String getExtensionMethod(int bitPos) {
        ArrayList arrayList = extensionMethods;
        synchronized (arrayList) {
            if (bitPos >= 0 && bitPos < extensionMethods.size()) {
                return (String)extensionMethods.get(bitPos);
            }
            throw new RuntimeException("invalid (extensionMethods) bit position: '" + bitPos + "' size: '" + extensionMethods.size() + " '");
        }
    }

    private static HttpMethodSpec getStandardSpec(String actions, BitSet set) {
        boolean isExceptionList = false;
        if (actions.charAt(0) == '!') {
            isExceptionList = true;
            if (actions.length() < 2) {
                throw new IllegalArgumentException("illegal HTTP method Spec actions: '" + actions + "'");
            }
            actions = actions.substring(1);
        }
        int map = HttpMethodSpec.makeMethodSet(actions, set);
        HttpMethodSpec rvalue = isExceptionList ? exceptionSpecArray[map] : specArray[map];
        return rvalue;
    }

    private static int makeMethodSet(String actions, BitSet set) {
        int i = 0;
        int mSet = 0;
        int commaPos = 0;
        while (commaPos >= 0 && i < actions.length()) {
            commaPos = actions.indexOf(comma, i);
            if (commaPos != 0) {
                String method = commaPos < 0 ? actions.substring(i) : actions.substring(i, commaPos);
                Integer bit = (Integer)methodHash.get(method);
                if (bit != null) {
                    mSet |= bit.intValue();
                } else {
                    HttpMethodSpec.setExtensionBit(method, set);
                }
                i = commaPos + 1;
                continue;
            }
            throw new IllegalArgumentException("illegal HTTP method Spec actions: '" + actions + "'");
        }
        return mSet;
    }

    private String getExtensionActions(String standardActions, int map, BitSet set) {
        String rvalue;
        ArrayList<String> methods = null;
        int i = set.nextSetBit(0);
        while (i >= 0) {
            if (methods == null) {
                methods = new ArrayList<String>();
            }
            methods.add(HttpMethodSpec.getExtensionMethod(i));
            i = set.nextSetBit(i + 1);
        }
        if (methods == null) {
            rvalue = standardActions;
        } else {
            Collections.sort(methods);
            StringBuffer actBuf = new StringBuffer(standardActions == null ? emptyString : standardActions);
            for (int i2 = 0; i2 < methods.size(); ++i2) {
                if (i2 > 0 || map > 0) {
                    actBuf.append(comma);
                }
                actBuf.append(methods.get(i2));
            }
            rvalue = actBuf.toString();
        }
        return rvalue;
    }

    private String getStandardActions(boolean isExceptionList, int map) {
        int bitValue = 1;
        StringBuffer actBuf = null;
        for (int i = 0; i < mapSize; ++i) {
            if ((map & bitValue) == bitValue) {
                if (actBuf == null) {
                    actBuf = new StringBuffer(isExceptionList ? exclaimationPoint : emptyString);
                } else {
                    actBuf.append(comma);
                }
                actBuf.append((String)methodKeys[i]);
            }
            bitValue *= 2;
        }
        if (actBuf == null) {
            return isExceptionList ? exclaimationPoint : emptyString;
        }
        return actBuf.toString();
    }

    static {
        int i;
        methodKeys = new Object[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
        mapSize = methodKeys.length;
        methodHash = new HashMap();
        int b = 1;
        for (int i2 = 0; i2 < mapSize; ++i2) {
            methodHash.put(methodKeys[i2], new Integer(b));
            b <<= 1;
        }
        allSet = 0;
        for (i = 0; i < mapSize; ++i) {
            allSet <<= 1;
            ++allSet;
        }
        specArray = new HttpMethodSpec[allSet + 1];
        for (i = 0; i < allSet + 1; ++i) {
            HttpMethodSpec.specArray[i] = new HttpMethodSpec(false, i);
        }
        exceptionSpecArray = new HttpMethodSpec[allSet + 1];
        for (i = 0; i < allSet + 1; ++i) {
            HttpMethodSpec.exceptionSpecArray[i] = new HttpMethodSpec(true, i);
        }
        allSpec = new HttpMethodSpec(false, 0);
        extensionMethods = new ArrayList();
    }
}

