/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.WrappedException;

public class ScriptException
extends RuntimeException {
    private final Throwable throwable_;
    private final String scriptSourceCode_;

    public ScriptException(Throwable throwable, String scriptSourceCode) {
        super(ScriptException.getMessageFrom(throwable));
        this.throwable_ = throwable;
        this.scriptSourceCode_ = scriptSourceCode;
    }

    private static String getMessageFrom(Throwable throwable) {
        if (throwable == null) {
            return "null";
        }
        return throwable.getMessage();
    }

    public ScriptException(Throwable throwable) {
        this(throwable, null);
    }

    public Throwable getEnclosedException() {
        return this.throwable_;
    }

    public void printStackTrace(PrintWriter writer) {
        writer.write(this.createPrintableStackTrace());
    }

    public void printStackTrace(PrintStream stream) {
        stream.print(this.createPrintableStackTrace());
    }

    private String createPrintableStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("======= EXCEPTION START ========");
        if (this.throwable_ != null) {
            if (this.throwable_ instanceof EcmaError) {
                EcmaError ecmaError = (EcmaError)this.throwable_;
                printWriter.print("EcmaError: ");
                printWriter.print("lineNumber=[");
                printWriter.print(ecmaError.getLineNumber());
                printWriter.print("] column=[");
                printWriter.print(ecmaError.getColumnNumber());
                printWriter.print("] lineSource=[");
                printWriter.print(this.getFailingLine());
                printWriter.print("] name=[");
                printWriter.print(ecmaError.getName());
                printWriter.print("] sourceName=[");
                printWriter.print(ecmaError.getSourceName());
                printWriter.print("] message=[");
                printWriter.print(ecmaError.getMessage());
                printWriter.print("] errorObject=[");
                printWriter.print(ecmaError.getErrorObject());
                printWriter.print("]");
                printWriter.println();
            } else {
                printWriter.println("Exception class=[" + this.throwable_.getClass().getName() + "]");
            }
        }
        super.printStackTrace(printWriter);
        if (this.throwable_ != null && this.throwable_ instanceof JavaScriptException) {
            Object value = ((JavaScriptException)this.throwable_).getValue();
            printWriter.print("JavaScriptException value = ");
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace(printWriter);
            } else {
                printWriter.println(value);
            }
        } else if (this.throwable_ != null && this.throwable_ instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)this.throwable_;
            printWriter.print("WrappedException: ");
            wrappedException.printStackTrace(printWriter);
            Throwable innerException = wrappedException.getWrappedException();
            if (innerException == null) {
                printWriter.println("Inside wrapped exception: null");
            } else {
                printWriter.println("Inside wrapped exception:");
                innerException.printStackTrace(printWriter);
            }
        } else if (this.throwable_ != null) {
            printWriter.println("Enclosed exception: ");
            this.throwable_.printStackTrace(printWriter);
        }
        if (this.scriptSourceCode_ != null && this.scriptSourceCode_.length() > 0) {
            printWriter.println("== CALLING JAVASCRIPT ==");
            printWriter.println(this.scriptSourceCode_);
        }
        printWriter.println("======= EXCEPTION END ========");
        return stringWriter.toString();
    }

    public String getScriptSourceCode() {
        return this.scriptSourceCode_;
    }

    public String getFailingLine() {
        int lineNumber = this.getFailingLineNumber();
        if (lineNumber == -1) {
            return "<no source>";
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(this.scriptSourceCode_));
            int i = 0;
            while (i < lineNumber - 1) {
                reader.readLine();
                ++i;
            }
            String result = reader.readLine();
            reader.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int getFailingLineNumber() {
        if (this.scriptSourceCode_ == null) {
            return -1;
        }
        if (this.throwable_ instanceof EcmaError) {
            EcmaError ecmaError = (EcmaError)this.throwable_;
            return ecmaError.getLineNumber();
        }
        return -1;
    }
}

