/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.CredentialProvider;
import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ScriptEngine;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.protocol.javascript.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebClient {
    private WebConnection webConnection_;
    private boolean printContentOnFailingStatusCode_ = true;
    private boolean throwExceptionOnFailingStatusCode_ = true;
    private CredentialProvider credentialProvider_ = new DenyAllCredentialProvider();
    private final String proxyHost_;
    private final int proxyPort_;
    private ScriptEngine scriptEngine_;
    private boolean javaScriptEnabled_ = true;
    private HtmlElement elementWithFocus_;
    private final Map requestHeaders_ = Collections.synchronizedMap(new HashMap(89));
    private AlertHandler alertHandler_;
    private ConfirmHandler confirmHandler_;
    private PromptHandler promptHandler_;
    private BrowserVersion browserVersion_ = BrowserVersion.getDefault();
    private boolean isRedirectEnabled_ = true;
    private PageCreator pageCreator_ = new DefaultPageCreator();
    private final Set webWindowListeners_ = new HashSet(5);
    private final List webWindows_ = new ArrayList();
    private WebWindow currentWindow_ = new TopLevelWindow("", this);
    private static URLStreamHandler JavaScriptUrlStreamHandler_ = new Handler();
    static /* synthetic */ Class class$junit$framework$AssertionFailedError;
    static /* synthetic */ Class class$java$lang$String;

    public WebClient() {
        this(BrowserVersion.FULL_FEATURED_BROWSER);
    }

    public WebClient(BrowserVersion browserVersion) {
        Assert.notNull("browserVersion", browserVersion);
        this.browserVersion_ = browserVersion;
        this.proxyHost_ = null;
        this.proxyPort_ = 0;
        try {
            this.scriptEngine_ = WebClient.createJavaScriptEngineIfPossible(this);
        }
        catch (NoClassDefFoundError e) {
            this.scriptEngine_ = null;
        }
    }

    public WebClient(BrowserVersion browserVersion, String proxyHost, int proxyPort) {
        Assert.notNull("browserVersion", browserVersion);
        Assert.notNull("proxyHost", proxyHost);
        this.proxyHost_ = proxyHost;
        this.proxyPort_ = proxyPort;
        try {
            this.scriptEngine_ = WebClient.createJavaScriptEngineIfPossible(this);
        }
        catch (NoClassDefFoundError e) {
            this.scriptEngine_ = null;
        }
    }

    public static JavaScriptEngine createJavaScriptEngineIfPossible(WebClient webClient) {
        try {
            Class.forName("org.mozilla.javascript.Context");
            return new JavaScriptEngine(webClient);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public synchronized WebConnection getWebConnection() {
        if (this.webConnection_ == null) {
            this.webConnection_ = this.proxyHost_ == null ? new HttpWebConnection(this) : new HttpWebConnection(this, this.proxyHost_, this.proxyPort_);
        }
        return this.webConnection_;
    }

    public void setWebConnection(WebConnection webConnection) {
        Assert.notNull("webConnection", webConnection);
        this.webConnection_ = webConnection;
    }

    public Page getPage(URL url) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow(), url, SubmitMethod.GET, Collections.EMPTY_LIST);
    }

    public Page getPage(URL url, SubmitMethod method, List parameters) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow(), url, method, parameters);
    }

    public Page getPage(WebWindow webWindow, URL url, SubmitMethod method, List parameters) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(webWindow, url, method, parameters, this.getThrowExceptionOnFailingStatusCode());
    }

    public Page getPage(WebWindow webWindow, URL url, SubmitMethod method, List parameters, boolean throwExceptionOnFailingStatusCode) throws IOException, FailingHttpStatusCodeException {
        boolean wasResponseSuccessful;
        String protocol = url.getProtocol();
        WebResponse webResponse = protocol.equals("javascript") ? this.makeWebResponseForJavaScriptUrl(webWindow, url) : this.loadWebResponse(url, method, parameters);
        String contentType = webResponse.getContentType();
        int statusCode = webResponse.getStatusCode();
        boolean bl = wasResponseSuccessful = statusCode >= 200 && statusCode < 300;
        if (this.printContentOnFailingStatusCode_ && !wasResponseSuccessful) {
            this.getLog().info((Object)("statusCode=[" + statusCode + "] contentType=[" + contentType + "]"));
            this.getLog().info((Object)webResponse.getContentAsString());
        }
        Page oldPage = webWindow.getEnclosedPage();
        Page newPage = this.pageCreator_.createPage(this, webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        newPage.initialize();
        this.fireWindowContentChanged(new WebWindowEvent(webWindow, oldPage, newPage));
        if (throwExceptionOnFailingStatusCode && !wasResponseSuccessful) {
            throw new FailingHttpStatusCodeException(statusCode, webResponse.getStatusMessage());
        }
        return webWindow.getEnclosedPage();
    }

    public void setPrintContentOnFailingStatusCode(boolean enabled) {
        this.printContentOnFailingStatusCode_ = enabled;
    }

    public boolean getPrintContentOnFailingStatusCode() {
        return this.printContentOnFailingStatusCode_;
    }

    public void setThrowExceptionOnFailingStatusCode(boolean enabled) {
        this.throwExceptionOnFailingStatusCode_ = enabled;
    }

    public boolean getThrowExceptionOnFailingStatusCode() {
        return this.throwExceptionOnFailingStatusCode_;
    }

    public void addRequestHeader(String name, String value) {
        this.requestHeaders_.put(name, value);
    }

    public void removeRequestHeader(String name) {
        this.requestHeaders_.remove(name);
    }

    public void setCredentialProvider(CredentialProvider credentialProvider) {
        Assert.notNull("credentialProvider", credentialProvider);
        this.credentialProvider_ = credentialProvider;
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider_;
    }

    public void assertionFailed(String message) {
        try {
            Class clazz = class$junit$framework$AssertionFailedError == null ? (class$junit$framework$AssertionFailedError = WebClient.class$("junit.framework.AssertionFailedError")) : class$junit$framework$AssertionFailedError;
            Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = WebClient.class$("java.lang.String")) : class$java$lang$String);
            Error error = (Error)constructor.newInstance(message);
            throw error;
        }
        catch (Exception e) {
            throw new IllegalStateException(message);
        }
    }

    public ScriptEngine getScriptEngine() {
        if (this.javaScriptEnabled_) {
            return this.scriptEngine_;
        }
        return null;
    }

    public void setScriptEngine(ScriptEngine engine) {
        this.scriptEngine_ = engine;
    }

    public void setJavaScriptEnabled(boolean isEnabled) {
        this.javaScriptEnabled_ = isEnabled;
    }

    public boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled_ && this.scriptEngine_ != null;
    }

    public void setAlertHandler(AlertHandler alertHandler) {
        this.alertHandler_ = alertHandler;
    }

    public AlertHandler getAlertHandler() {
        return this.alertHandler_;
    }

    public void setConfirmHandler(ConfirmHandler handler) {
        this.confirmHandler_ = handler;
    }

    public ConfirmHandler getConfirmHandler() {
        return this.confirmHandler_;
    }

    public void setPromptHandler(PromptHandler handler) {
        this.promptHandler_ = handler;
    }

    public PromptHandler getPromptHandler() {
        return this.promptHandler_;
    }

    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }

    public WebWindow getCurrentWindow() {
        return this.currentWindow_;
    }

    public void setCurrentWindow(WebWindow window) {
        Assert.notNull("window", window);
        this.currentWindow_ = window;
    }

    public void addWebWindowListener(WebWindowListener listener) {
        Assert.notNull("listener", listener);
        this.webWindowListeners_.add(listener);
    }

    public void removeWebWindowListener(WebWindowListener listener) {
        Assert.notNull("listener", listener);
        this.webWindowListeners_.remove(listener);
    }

    private void fireWindowContentChanged(WebWindowEvent event) {
        Iterator iterator = ((AbstractList)new ArrayList(this.webWindowListeners_)).iterator();
        while (iterator.hasNext()) {
            WebWindowListener listener = (WebWindowListener)iterator.next();
            listener.webWindowContentChanged(event);
        }
    }

    private void fireWindowOpened(WebWindowEvent event) {
        Iterator iterator = ((AbstractList)new ArrayList(this.webWindowListeners_)).iterator();
        while (iterator.hasNext()) {
            WebWindowListener listener = (WebWindowListener)iterator.next();
            listener.webWindowOpened(event);
        }
    }

    public WebWindow openWindow(URL url, String windowName) {
        Assert.notNull("windowName", windowName);
        return this.openWindow(url, windowName, null);
    }

    public WebWindow openWindow(URL url, String windowName, WebWindow opener) {
        WebWindow window;
        block10: {
            if (windowName == null) {
                windowName = "";
            }
            window = null;
            if (windowName.equals("_self")) {
                window = this.getCurrentWindow();
            } else if (windowName.length() != 0) {
                try {
                    window = this.getWebWindowByName(windowName);
                }
                catch (WebWindowNotFoundException e) {
                    // empty catch block
                }
            }
            if (window == null) {
                window = new TopLevelWindow(windowName, this);
                this.fireWindowOpened(new WebWindowEvent(window, null, null));
            }
            if (window instanceof TopLevelWindow) {
                ((TopLevelWindow)window).setOpener(opener);
            }
            if (url == null) break block10;
            try {
                this.getPage(window, url, SubmitMethod.GET, Collections.EMPTY_LIST);
            }
            catch (IOException e) {
                this.getLog().error((Object)"Error when loading content into newly created window", (Throwable)e);
            }
        }
        return window;
    }

    public void setRedirectEnabled(boolean enabled) {
        this.isRedirectEnabled_ = enabled;
    }

    public boolean isRedirectEnabled() {
        return this.isRedirectEnabled_;
    }

    public void setPageCreator(PageCreator pageCreator) {
        Assert.notNull("pageCreator", pageCreator);
        this.pageCreator_ = pageCreator;
    }

    public PageCreator getPageCreator() {
        return this.pageCreator_;
    }

    public WebWindow getWebWindowByName(String name) throws WebWindowNotFoundException {
        Assert.notNull("name", name);
        Iterator iterator = this.webWindows_.iterator();
        while (iterator.hasNext()) {
            WebWindow webWindow = (WebWindow)iterator.next();
            if (!webWindow.getName().equals(name)) continue;
            return webWindow;
        }
        throw new WebWindowNotFoundException(name);
    }

    public void registerWebWindow(WebWindow webWindow) {
        Assert.notNull("webWindow", webWindow);
        this.webWindows_.add(webWindow);
    }

    public void deregisterWebWindow(WebWindow webWindow) {
        Assert.notNull("webWindow", webWindow);
        this.webWindows_.remove(webWindow);
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private static URL makeUrl(String urlString) throws MalformedURLException {
        Assert.notNull("urlString", urlString);
        if (TextUtil.startsWithIgnoreCase(urlString, "javascript:")) {
            return new URL(null, urlString, JavaScriptUrlStreamHandler_);
        }
        return new URL(urlString);
    }

    public static URL expandUrl(URL baseUrl, String relativeUrl) throws MalformedURLException {
        String stringToTokenize;
        if (relativeUrl.indexOf(":") != -1) {
            return WebClient.makeUrl(relativeUrl);
        }
        if (relativeUrl.startsWith("//")) {
            return WebClient.makeUrl(baseUrl.getProtocol() + ":" + relativeUrl);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        if (relativeUrl.length() == 0) {
            stringToTokenize = baseUrl.getPath();
        } else if (relativeUrl.startsWith("/")) {
            stringToTokenize = relativeUrl;
        } else {
            String path = baseUrl.getPath();
            if (!path.endsWith("/")) {
                path = path + "/..";
            }
            stringToTokenize = path + "/" + relativeUrl;
        }
        StringTokenizer tokenizer = new StringTokenizer(stringToTokenize, "/");
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        int i = 0;
        while (i < tokens.size()) {
            String oneToken = (String)tokens.get(i);
            if (oneToken.length() == 0 || oneToken.equals(".")) {
                tokens.remove(i--);
            } else if (oneToken.equals("..")) {
                tokens.remove(i--);
                if (i >= 0) {
                    tokens.remove(i--);
                }
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(baseUrl.getProtocol());
        buffer.append("://");
        buffer.append(baseUrl.getHost());
        int port = baseUrl.getPort();
        if (port != -1) {
            buffer.append(":");
            buffer.append(port);
        }
        Iterator iterator = tokens.iterator();
        while (iterator.hasNext()) {
            buffer.append("/");
            buffer.append(iterator.next());
        }
        if (tokens.isEmpty() || stringToTokenize.endsWith("/")) {
            buffer.append("/");
        }
        return WebClient.makeUrl(buffer.toString());
    }

    private WebResponse makeWebResponseForJavaScriptUrl(WebWindow webWindow, final URL url) {
        if (!(webWindow instanceof HtmlElement)) {
            throw new IllegalArgumentException("javascript urls can only be used to load content into frames and iframes");
        }
        HtmlPage enclosingPage = ((HtmlElement)((Object)webWindow)).getPage();
        ScriptResult scriptResult = enclosingPage.executeJavaScriptIfPossible(url.toExternalForm(), "javascript url", false, null);
        final String contentString = scriptResult.getJavaScriptResult().toString();
        return new WebResponse(){

            public int getStatusCode() {
                return 200;
            }

            public String getStatusMessage() {
                return "OK";
            }

            public String getContentType() {
                return "text/html";
            }

            public String getContentAsString() {
                return contentString;
            }

            public InputStream getContentAsStream() {
                return TextUtil.toInputStream(contentString);
            }

            public URL getUrl() {
                return url;
            }

            public String getResponseHeaderValue(String key) {
                return "";
            }

            public long getLoadTimeInMilliSeconds() {
                return 0L;
            }

            public byte[] getResponseBody() {
                try {
                    return contentString.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }

            public String getContentCharSet() {
                return "ISO-8859-1";
            }
        };
    }

    public final WebResponse loadWebResponse(URL url, SubmitMethod method, List parameters) throws IOException {
        Assert.notNull("url", url);
        Assert.notNull("method", method);
        Assert.notNull("parameters", parameters);
        WebResponse webResponse = this.getWebConnection().getResponse(url, method, parameters, this.requestHeaders_);
        int statusCode = webResponse.getStatusCode();
        if (statusCode >= 301 && statusCode <= 307 && this.isRedirectEnabled()) {
            URL newUrl = null;
            String locationString = null;
            try {
                locationString = webResponse.getResponseHeaderValue("Location");
                if (locationString != null) {
                    int indexOfComma = locationString.indexOf(44);
                    newUrl = indexOfComma >= 0 ? WebClient.expandUrl(url, locationString.substring(0, indexOfComma)) : WebClient.expandUrl(url, locationString);
                }
            }
            catch (MalformedURLException e) {
                this.getLog().warn((Object)("Got a redirect status code [" + statusCode + " " + webResponse.getStatusMessage() + "] but the location is not a valid url [" + locationString + "]"));
            }
            this.getLog().debug((Object)("Got a redirect status code [" + statusCode + "] new location=[" + locationString + "]"));
            if (webResponse.getUrl().toExternalForm().equals(locationString)) {
                this.getLog().warn((Object)("Got a redirect but the location is the same as the page we just loaded [" + locationString + "]"));
            } else if (newUrl != null) {
                if ((statusCode == 301 || statusCode == 307) && method.equals(SubmitMethod.GET)) {
                    return this.loadWebResponse(newUrl, SubmitMethod.GET, parameters);
                }
                if (statusCode == 302 || statusCode == 303) {
                    return this.loadWebResponse(newUrl, SubmitMethod.GET, Collections.EMPTY_LIST);
                }
            }
        }
        return webResponse;
    }

    public boolean moveFocusToElement(HtmlElement newElement) {
        Page newPage;
        HtmlPage currentPage;
        String onFocusHandler;
        String onBlurHandler;
        if (this.elementWithFocus_ == newElement) {
            return true;
        }
        if (newElement != null && !newElement.getPage().getTabbableElements().contains(newElement)) {
            return false;
        }
        if (this.elementWithFocus_ != null && (onBlurHandler = this.elementWithFocus_.getAttributeValue("onblur")).length() != 0) {
            this.elementWithFocus_.getPage().executeJavaScriptIfPossible(onBlurHandler, "OnBlur handler", true, this.elementWithFocus_);
        }
        if (newElement != null && (onFocusHandler = newElement.getAttributeValue("onfocus")).length() != 0 && (currentPage = newElement.getPage()) != (newPage = currentPage.executeJavaScriptIfPossible(onFocusHandler, "OnFocus handler", true, newElement).getNewPage())) {
            this.elementWithFocus_ = null;
            return false;
        }
        this.elementWithFocus_ = newElement;
        return true;
    }

    public HtmlElement getElementWithFocus() {
        return this.elementWithFocus_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DenyAllCredentialProvider
    implements CredentialProvider {
        private DenyAllCredentialProvider() {
        }

        public KeyValuePair getCredentialsFor(String server, int port, String realm) {
            return null;
        }
    }
}

