/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class HtmlAnchor
extends HtmlElement {
    HtmlAnchor(HtmlPage page, Element element) {
        super(page, element);
    }

    public Page click() throws IOException {
        HtmlPage page = this.getPage();
        String href = this.getHrefAttribute();
        String onClick = this.getOnClickAttribute();
        if (onClick.length() != 0 && page.getWebClient().isJavaScriptEnabled()) {
            ScriptResult scriptResult = page.executeJavaScriptIfPossible(onClick, "onClick handler", true, this);
            if (scriptResult.getJavaScriptResult().equals(Boolean.FALSE)) {
                return scriptResult.getNewPage();
            }
            URL url = page.getFullyQualifiedUrl(this.getHrefAttribute());
            SubmitMethod submitMethod = SubmitMethod.GET;
            List parameters = Collections.EMPTY_LIST;
            return page.getWebClient().getPage(url, submitMethod, parameters);
        }
        if (TextUtil.startsWithIgnoreCase(href, "javascript:")) {
            return page.executeJavaScriptIfPossible(href, "javascript url", true, this).getNewPage();
        }
        URL url = page.getFullyQualifiedUrl(this.getHrefAttribute());
        SubmitMethod submitMethod = SubmitMethod.GET;
        List parameters = Collections.EMPTY_LIST;
        return page.getWebClient().getPage(url, submitMethod, parameters);
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getCharsetAttribute() {
        return this.getAttributeValue("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getHrefAttribute() {
        return this.getAttributeValue("href");
    }

    public final String getHrefLangAttribute() {
        return this.getAttributeValue("hreflang");
    }

    public final String getRelAttribute() {
        return this.getAttributeValue("rel");
    }

    public final String getRevAttribute() {
        return this.getAttributeValue("rev");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getShapeAttribute() {
        return this.getAttributeValue("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttributeValue("coords");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttributeValue("target");
    }
}

