/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.w3c.dom.Element;

public class HtmlInlineFrame
extends HtmlElement
implements WebWindow {
    private Page enclosedPage_;

    public HtmlInlineFrame(HtmlPage page, Element xmlElement) {
        super(page, xmlElement);
        WebClient webClient = page.getWebClient();
        webClient.registerWebWindow(this);
        this.loadInnerPageIfPossible(this.getSrcAttribute(), webClient);
    }

    private void loadInnerPageIfPossible(String srcAttribute, WebClient webClient) {
        block3: {
            if (srcAttribute.length() == 0) break block3;
            URL url = null;
            try {
                url = this.getPage().getFullyQualifiedUrl(srcAttribute);
                this.setEnclosedPage(webClient.getPage(this, url, SubmitMethod.GET, Collections.EMPTY_LIST, false));
            }
            catch (MalformedURLException e) {
                this.getLog().error((Object)("Bad url in src attribute of iframe: url=[" + srcAttribute + "]"), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().error((Object)("IOException when getting content for iframe: url=[" + url.toExternalForm() + "]"), (Throwable)e);
            }
        }
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLongDescAttribute() {
        return this.getAttributeValue("longdesc");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getSrcAttribute() {
        return this.getAttributeValue("src");
    }

    public final void setSrcAttribute(String attribute) {
        this.getElement().setAttribute("src", attribute);
        this.loadInnerPageIfPossible(attribute, this.getPage().getWebClient());
    }

    public final String getFrameBorderAttribute() {
        return this.getAttributeValue("frameborder");
    }

    public final String getMarginWidthAttribute() {
        return this.getAttributeValue("marginwidth");
    }

    public final String getMarginHeightAttribute() {
        return this.getAttributeValue("marginheight");
    }

    public final String getScrollingAttribute() {
        return this.getAttributeValue("scrolling");
    }

    public final String getAlignAttribute() {
        return this.getAttributeValue("align");
    }

    public final String getHeightAttribute() {
        return this.getAttributeValue("height");
    }

    public final String getWidthAttribute() {
        return this.getAttributeValue("width");
    }

    public String getName() {
        return this.getNameAttribute();
    }

    public Page getEnclosedPage() {
        return this.enclosedPage_;
    }

    public void setEnclosedPage(Page page) {
        this.enclosedPage_ = page;
    }

    public WebClient getWebClient() {
        return this.getPage().getWebClient();
    }
}

