/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import org.w3c.dom.Element;

public class HtmlOption
extends HtmlElement {
    private final boolean initialSelectedState_ = this.isAttributeDefined("selected");

    HtmlOption(HtmlPage page, Element element) {
        super(page, element);
    }

    public boolean isSelected() {
        return this.isAttributeDefined("selected");
    }

    public void setSelected(boolean selected) {
        String value = this.getValueAttribute();
        if (value.length() == 0) {
            throw new IllegalStateException("Can't select this option because it has no value set");
        }
        this.getEnclosingSelectOrDie().setSelectedAttribute(value, selected);
    }

    private HtmlSelect getEnclosingSelectOrDie() {
        HtmlElement parent = this.getParent();
        while (parent != null) {
            if (parent instanceof HtmlSelect) {
                return (HtmlSelect)parent;
            }
            parent = parent.getParent();
        }
        throw new IllegalStateException("Can't find enclosing select element");
    }

    public void reset() {
        if (this.initialSelectedState_) {
            this.getElement().setAttribute("selected", "selected");
        } else {
            this.getElement().removeAttribute("selected");
        }
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getSelectedAttribute() {
        return this.getAttributeValue("selected");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getLabelAttribute() {
        return this.getAttributeValue("label");
    }

    public final String getValueAttribute() {
        return this.getAttributeValue("value");
    }
}

