/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptEngine;
import com.gargoylesoftware.htmlunit.ScriptFilter;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlElementCreator;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlInputElementCreator;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.SimpleHtmlElementCreator;
import com.gargoylesoftware.htmlunit.html.TableElementCreator;
import com.gargoylesoftware.htmlunit.html.UnknownHtmlElement;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HtmlPage
extends HtmlElement
implements Page {
    private MyParser xmlParser_;
    private Document document_;
    private final WebClient webClient_;
    private final URL originatingUrl_;
    private String originalCharset_ = null;
    private final Map elements_ = new HashMap(89);
    private final WebResponse webResponse_;
    private WebWindow enclosingWindow_;
    private static int FunctionWrapperCount_ = 0;
    private static final Map HTML_ELEMENT_CREATORS = new TreeMap();
    private static final int TAB_INDEX_NOT_SPECIFIED = -10;
    private static final int TAB_INDEX_OUT_OF_BOUNDS = -20;
    private ScriptFilter scriptFilter_;
    private Object onLoad_;

    public HtmlPage(WebClient webClient, URL originatingUrl, WebResponse webResponse, WebWindow webWindow) throws IOException {
        super(null, null);
        Assert.notNull("webClient", webClient);
        Assert.notNull("originatingUrl", originatingUrl);
        Assert.notNull("webResponse", webResponse);
        Assert.notNull("webWindow", webWindow);
        this.webClient_ = webClient;
        this.originatingUrl_ = originatingUrl;
        this.webResponse_ = webResponse;
        this.setEnclosingWindow(webWindow);
        webWindow.setEnclosedPage(this);
    }

    public void initialize() throws IOException {
        HtmlPage.initializeHtmlElementCreatorsIfNeeded();
        this.document_ = this.createDocument(this.webResponse_);
        this.setElement(this.document_.getDocumentElement());
        this.executeJavaScriptIfPossible("", "Dummy stub just to get javascript initialized", false, null);
        this.initializeFramesIfNeeded();
        this.executeBodyOnLoadHandlerIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeHtmlElementCreatorsIfNeeded() {
        Map map = HTML_ELEMENT_CREATORS;
        synchronized (map) {
            if (HTML_ELEMENT_CREATORS.isEmpty()) {
                HTML_ELEMENT_CREATORS.put("input", new HtmlInputElementCreator());
                HTML_ELEMENT_CREATORS.put("tr", new TableElementCreator());
                HTML_ELEMENT_CREATORS.put("td", new TableElementCreator());
                HTML_ELEMENT_CREATORS.put("th", new TableElementCreator());
                String[][] simpleHtmlElementCreatorData = new String[][]{{"a", "HtmlAnchor"}, {"applet", "HtmlApplet"}, {"address", "HtmlAddress"}, {"area", "HtmlArea"}, {"base", "HtmlBase"}, {"basefont", "HtmlBaseFont"}, {"bdo", "HtmlBidirectionalOverride"}, {"blockquote", "HtmlBlockQuote"}, {"body", "HtmlBody"}, {"br", "HtmlBreak"}, {"button", "HtmlButton"}, {"caption", "HtmlCaption"}, {"center", "HtmlCenter"}, {"col", "HtmlTableColumn"}, {"colgroup", "HtmlTableColumnGroup"}, {"dd", "HtmlDefinitionDescription"}, {"del", "HtmlDeletedText"}, {"dir", "HtmlTextDirection"}, {"div", "HtmlDivision"}, {"dl", "HtmlDefinitionList"}, {"dt", "HtmlDefinitionTerm"}, {"fieldset", "HtmlFieldSet"}, {"font", "HtmlFont"}, {"form", "HtmlForm"}, {"frame", "HtmlFrame"}, {"frameset", "HtmlFrameSet"}, {"h1", "HtmlHeader1"}, {"h2", "HtmlHeader2"}, {"h3", "HtmlHeader3"}, {"h4", "HtmlHeader4"}, {"h5", "HtmlHeader5"}, {"h6", "HtmlHeader6"}, {"head", "HtmlHead"}, {"hr", "HtmlHorizontalRule"}, {"iframe", "HtmlInlineFrame"}, {"img", "HtmlImage"}, {"ins", "HtmlInsertedText"}, {"isindex", "HtmlIsIndex"}, {"label", "HtmlLabel"}, {"legend", "HtmlLegend"}, {"li", "HtmlListItem"}, {"link", "HtmlLink"}, {"map", "HtmlMap"}, {"menu", "HtmlMenu"}, {"meta", "HtmlMeta"}, {"noframes", "HtmlNoFrames"}, {"noscript", "HtmlNoScript"}, {"object", "HtmlObject"}, {"ol", "HtmlOrderedList"}, {"optgroup", "HtmlOptionGroup"}, {"option", "HtmlOption"}, {"p", "HtmlParagraph"}, {"param", "HtmlParameter"}, {"pre", "HtmlPreformattedText"}, {"q", "HtmlInlineQuotation"}, {"script", "HtmlScript"}, {"select", "HtmlSelect"}, {"span", "HtmlSpan"}, {"style", "HtmlStyle"}, {"title", "HtmlTitle"}, {"table", "HtmlTable"}, {"tbody", "HtmlTableBody"}, {"textarea", "HtmlTextArea"}, {"tfoot", "HtmlTableFooter"}, {"thead", "HtmlTableHeader"}, {"ul", "HtmlUnorderedList"}};
                int i = 0;
                while (i < simpleHtmlElementCreatorData.length) {
                    Class<?> clazz;
                    String tagName = simpleHtmlElementCreatorData[i][0];
                    try {
                        clazz = Class.forName("com.gargoylesoftware.htmlunit.html." + simpleHtmlElementCreatorData[i][1]);
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(simpleHtmlElementCreatorData[i][1]);
                    }
                    HTML_ELEMENT_CREATORS.put(tagName, new SimpleHtmlElementCreator(clazz));
                    ++i;
                }
            }
        }
    }

    private Document createDocument(WebResponse webResponse) throws IOException {
        InputStream inputStream = webResponse.getContentAsStream();
        this.xmlParser_ = new MyParser();
        try {
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new ScriptFilter(this.xmlParser_.getConfiguration(), this)};
            this.xmlParser_.setProperty("http://cyberneko.org/html/properties/filters", filters);
            this.xmlParser_.setFeature("http://cyberneko.org/html/features/augmentations", true);
            this.xmlParser_.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
            this.xmlParser_.setFeature("http://cyberneko.org/html/features/report-errors", true);
            this.xmlParser_.parse(new InputSource(inputStream));
            Document document = this.xmlParser_.getDocument();
            this.xmlParser_ = null;
            return document;
        }
        catch (SAXException e) {
            throw new ObjectInstantiationException("Unable to parse html input", e);
        }
    }

    public String getPageEncoding() {
        if (this.originalCharset_ != null) {
            return this.originalCharset_;
        }
        ArrayList<String> ar = new ArrayList<String>();
        ar.add("meta");
        List list = this.getHtmlElementsByTagNames(ar);
        int i = 0;
        while (i < list.size()) {
            String contents;
            int pos;
            HtmlMeta meta = (HtmlMeta)list.get(i);
            String httpequiv = meta.getHttpEquivAttribute();
            if ("content-type".equals(httpequiv.toLowerCase()) && (pos = (contents = meta.getContentAttribute()).toLowerCase().indexOf("charset=")) >= 0) {
                this.originalCharset_ = contents.substring(pos + 8);
                this.getLog().debug((Object)("Page Encoding detected:" + this.originalCharset_));
                return this.originalCharset_;
            }
            ++i;
        }
        if (this.originalCharset_ == null) {
            this.originalCharset_ = this.webResponse_.getContentCharSet();
        }
        return this.originalCharset_;
    }

    public Element getElement() {
        Element element = super.getElement();
        if (element == null && this.xmlParser_ != null) {
            return this.xmlParser_.getDocument().getDocumentElement();
        }
        return element;
    }

    public Document getDocument() {
        if (this.document_ == null && this.xmlParser_ != null) {
            this.document_ = this.xmlParser_.getDocument();
        }
        return this.document_;
    }

    public HtmlElement createElement(String tagName) {
        Document document = this.getDocument();
        Element xmlElement = document.createElement(tagName);
        HtmlElement element = this.getHtmlElement(xmlElement);
        return element;
    }

    public HtmlAnchor getAnchorByName(String name) throws ElementNotFoundException {
        return (HtmlAnchor)this.getPage().getOneHtmlElementByAttribute("a", "name", name);
    }

    public HtmlAnchor getAnchorByHref(String href) throws ElementNotFoundException {
        return (HtmlAnchor)this.getPage().getOneHtmlElementByAttribute("a", "href", href);
    }

    public List getAnchors() {
        return this.getHtmlElementsByTagNames(Collections.singletonList("a"));
    }

    public HtmlAnchor getFirstAnchorByText(String text) throws ElementNotFoundException {
        Assert.notNull("text", text);
        Iterator iterator = this.getAnchors().iterator();
        while (iterator.hasNext()) {
            HtmlAnchor anchor = (HtmlAnchor)iterator.next();
            if (!text.equals(anchor.asText())) continue;
            return anchor;
        }
        throw new ElementNotFoundException("a", "<text>", text);
    }

    public HtmlElement getHtmlElement(Element xmlElement) {
        if (xmlElement == null) {
            return null;
        }
        HtmlElement htmlElement = (HtmlElement)this.elements_.get(xmlElement);
        if (htmlElement != null) {
            return htmlElement;
        }
        String tagName = this.getTagName(xmlElement);
        HtmlElementCreator creator = (HtmlElementCreator)HTML_ELEMENT_CREATORS.get(tagName);
        HtmlElement newHtmlElement = creator == null ? new UnknownHtmlElement(this, xmlElement) : creator.create(this, xmlElement);
        this.elements_.put(xmlElement, newHtmlElement);
        return newHtmlElement;
    }

    public HtmlForm getFormByName(String name) throws ElementNotFoundException {
        List forms = this.getHtmlElementsByAttribute("form", "name", name);
        if (forms.size() == 0) {
            throw new ElementNotFoundException("form", "name", name);
        }
        return (HtmlForm)forms.get(0);
    }

    public List getAllForms() {
        return this.getHtmlElementsByTagNames(Arrays.asList("form"));
    }

    public WebClient getWebClient() {
        return this.webClient_;
    }

    public URL getFullyQualifiedUrl(String relativeUrl) throws MalformedURLException {
        URL baseUrl;
        List baseElements = this.getHtmlElementsByTagNames(Collections.singletonList("base"));
        if (baseElements.isEmpty()) {
            baseUrl = this.originatingUrl_;
        } else {
            HtmlBase htmlBase = (HtmlBase)baseElements.get(0);
            baseUrl = new URL(htmlBase.getHrefAttribute());
        }
        return WebClient.expandUrl(baseUrl, relativeUrl);
    }

    public WebResponse getWebResponse() {
        return this.webResponse_;
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final List getTabbableElementIds() {
        ArrayList<String> list = new ArrayList<String>(this.getTabbableElements());
        int listSize = list.size();
        int i = 0;
        while (i < listSize) {
            list.set(i, ((HtmlElement)list.get(i)).getAttributeValue("id"));
            ++i;
        }
        return Collections.unmodifiableList(list);
    }

    public List getTabbableElements() {
        List<Object> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        ArrayList<HtmlElement> tabbableElements = new ArrayList<HtmlElement>();
        HtmlPage page = this.getPage();
        Iterator xmlIterator = this.getXmlChildElements();
        while (xmlIterator.hasNext()) {
            Element xmlElement = (Element)xmlIterator.next();
            String tagName = this.getTagName(xmlElement);
            if (!acceptableTagNames.contains(tagName)) continue;
            String disabledAttribute = this.getAttributeValue(xmlElement, "disabled");
            boolean isDisabled = disabledAttribute != HtmlElement.ATTRIBUTE_NOT_DEFINED;
            HtmlElement htmlElement = page.getHtmlElement(xmlElement);
            if (isDisabled || this.getTabIndex(htmlElement) == -20) continue;
            tabbableElements.add(htmlElement);
        }
        Collections.sort(tabbableElements, this.createTabOrderComparator());
        return Collections.unmodifiableList(tabbableElements);
    }

    private Comparator createTabOrderComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                HtmlElement element1 = (HtmlElement)object1;
                HtmlElement element2 = (HtmlElement)object2;
                int tabIndex1 = HtmlPage.this.getTabIndex(element1);
                int tabIndex2 = HtmlPage.this.getTabIndex(element2);
                int result = tabIndex1 > 0 && tabIndex2 > 0 ? tabIndex1 - tabIndex2 : (tabIndex1 > 0 ? -1 : (tabIndex2 > 0 ? 1 : (tabIndex1 == tabIndex2 ? 0 : tabIndex2 - tabIndex1)));
                return result;
            }
        };
    }

    private int getTabIndex(HtmlElement element) {
        String tabIndexAttribute = element.getAttributeValue("tabindex");
        if (tabIndexAttribute == null || tabIndexAttribute.length() == 0) {
            return -10;
        }
        int tabIndex = Integer.parseInt(tabIndexAttribute);
        if (tabIndex >= 0 && tabIndex <= Short.MAX_VALUE) {
            return tabIndex;
        }
        return -20;
    }

    public HtmlElement getHtmlElementByAccessKey(char accessKey) {
        List elements = this.getHtmlElementsByAccessKey(accessKey);
        if (elements.isEmpty()) {
            return null;
        }
        return (HtmlElement)elements.get(0);
    }

    public List getHtmlElementsByAccessKey(char accessKey) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        String searchString = ("" + accessKey).toLowerCase();
        List<Object> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "label", "legend", "textarea");
        Iterator xmlIterator = this.getXmlChildElements();
        while (xmlIterator.hasNext()) {
            String accessKeyAttribute;
            Element xmlElement = (Element)xmlIterator.next();
            if (!acceptableTagNames.contains(this.getTagName(xmlElement)) || !searchString.equalsIgnoreCase(accessKeyAttribute = this.getAttributeValue(xmlElement, "accesskey"))) continue;
            elements.add(this.getPage().getHtmlElement(xmlElement));
        }
        return elements;
    }

    public void assertAllAccessKeyAttributesUnique() {
        ArrayList<String> accessKeyList = new ArrayList<String>();
        Iterator xmlIterator = this.getXmlChildElements();
        while (xmlIterator.hasNext()) {
            String id = this.getAttributeValue((Element)xmlIterator.next(), "accesskey");
            if (id == null || id.length() == 0) continue;
            if (accessKeyList.contains(id)) {
                this.webClient_.assertionFailed("Duplicate access key: " + id);
                continue;
            }
            accessKeyList.add(id);
        }
    }

    public void assertAllIdAttributesUnique() {
        ArrayList<String> idList = new ArrayList<String>();
        Iterator xmlIterator = this.getXmlChildElements();
        while (xmlIterator.hasNext()) {
            String id = this.getAttributeValue((Element)xmlIterator.next(), "id");
            if (id == null || id.length() == 0) continue;
            if (idList.contains(id)) {
                this.webClient_.assertionFailed("Duplicate ID: " + id);
                continue;
            }
            idList.add(id);
        }
    }

    public void assertAllTabIndexAttributesSet() {
        List<Object> acceptableTagNames = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        List tabbableElements = this.getHtmlElementsByTagNames(acceptableTagNames);
        Iterator iterator = tabbableElements.iterator();
        while (iterator.hasNext()) {
            HtmlElement htmlElement = (HtmlElement)iterator.next();
            int tabIndex = this.getTabIndex(htmlElement);
            if (tabIndex == -20) {
                this.webClient_.assertionFailed("Illegal value for tab index: " + htmlElement.getAttributeValue("tabindex"));
                continue;
            }
            if (tabIndex != -10) continue;
            this.webClient_.assertionFailed("tabindex not set for " + htmlElement);
        }
    }

    public ScriptResult executeJavaScriptIfPossible(String sourceCode, String sourceName, boolean wrapSourceInFunction, HtmlElement htmlElement) {
        Object result;
        ScriptEngine engine = this.getWebClient().getScriptEngine();
        if (engine == null) {
            return new ScriptResult(null, this);
        }
        String prefix = "javascript:";
        int prefixLength = "javascript:".length();
        if (sourceCode.length() > prefixLength && sourceCode.substring(0, prefixLength).equalsIgnoreCase("javascript:")) {
            sourceCode = sourceCode.substring(prefixLength);
        }
        WebWindow window = this.getEnclosingWindow();
        if (wrapSourceInFunction) {
            String wrapperName = "GargoyleWrapper" + FunctionWrapperCount_++;
            sourceCode = "function " + wrapperName + "() {" + sourceCode + "\n}";
            engine.execute(this, sourceCode, "Wrapper definition for " + sourceName, htmlElement);
            result = engine.execute(this, wrapperName + "()", sourceName, htmlElement);
        } else {
            result = engine.execute(this, sourceCode, sourceName, htmlElement);
        }
        return new ScriptResult(result, window.getEnclosedPage());
    }

    public void loadExternalJavaScriptFile(String srcAttribute) {
        this.loadExternalJavaScriptFile(srcAttribute, null);
    }

    public void loadExternalJavaScriptFile(String srcAttribute, String charset) {
        ScriptEngine engine = this.getWebClient().getScriptEngine();
        if (engine != null) {
            engine.execute(this, this.loadJavaScriptFromUrl(srcAttribute, charset), srcAttribute, null);
        }
    }

    public boolean isJavaScript(String typeAttribute, String languageAttribute) {
        boolean isJavaScript = languageAttribute != null && languageAttribute.length() != 0 ? TextUtil.startsWithIgnoreCase(languageAttribute, "javascript") : (typeAttribute != null && typeAttribute.length() != 0 ? typeAttribute.equals("text/javascript") : true);
        return isJavaScript;
    }

    private String loadJavaScriptFromUrl(String urlString, String charset) {
        URL url = null;
        String scriptEncoding = charset;
        this.getPageEncoding();
        try {
            url = this.getFullyQualifiedUrl(urlString);
            WebResponse webResponse = this.getWebClient().loadWebResponse(url, SubmitMethod.GET, Collections.EMPTY_LIST);
            if (webResponse.getStatusCode() == 200) {
                String contentType = webResponse.getContentType();
                String contentCharset = webResponse.getContentCharSet();
                if (!contentType.equals("text/javascript") && !contentType.equals("application/x-javascript")) {
                    this.getLog().warn((Object)("Expected content type of text/javascript or application/x-javascript for remotely loaded javascript element but got [" + webResponse.getContentType() + "]"));
                }
                if (scriptEncoding == null || scriptEncoding.length() == 0) {
                    if (!contentCharset.equals("ISO-8859-1")) {
                        scriptEncoding = contentCharset;
                    } else if (!this.originalCharset_.equals("ISO-8859-1")) {
                        scriptEncoding = this.originalCharset_;
                    }
                }
                if (scriptEncoding == null || scriptEncoding.length() == 0) {
                    scriptEncoding = "ISO-8859-1";
                }
                byte[] data = webResponse.getResponseBody();
                return HttpConstants.getContentString((byte[])data, (int)0, (int)data.length, (String)scriptEncoding);
            }
            this.getLog().error((Object)("Error loading javascript from [" + url.toExternalForm() + "] status=[" + webResponse.getStatusCode() + " " + webResponse.getStatusMessage() + "]"));
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)("Unable to build url for script src tag [" + urlString + "]"));
            return "";
        }
        catch (Exception e) {
            this.getLog().error((Object)("Error loading javascript from [" + url.toExternalForm() + "]: "), (Throwable)e);
        }
        return "";
    }

    public WebWindow getEnclosingWindow() {
        return this.enclosingWindow_;
    }

    public void setEnclosingWindow(WebWindow window) {
        this.enclosingWindow_ = window;
    }

    public String getTitleText() {
        Iterator topIterator = this.getChildElements().iterator();
        while (topIterator.hasNext()) {
            HtmlElement topElement = (HtmlElement)topIterator.next();
            if (!(topElement instanceof HtmlHead)) continue;
            Iterator headIterator = topElement.getChildElements().iterator();
            while (headIterator.hasNext()) {
                HtmlElement headElement = (HtmlElement)headIterator.next();
                if (!(headElement instanceof HtmlTitle)) continue;
                return headElement.asText();
            }
        }
        return "";
    }

    private String getBodyOnLoadAttribute() {
        String onLoad;
        List bodyTags = this.getHtmlElementsByTagNames(Collections.singletonList("body"));
        int bodyTagCount = bodyTags.size();
        if (bodyTagCount == 0) {
            onLoad = "";
        } else if (bodyTagCount == 1) {
            HtmlBody body = (HtmlBody)bodyTags.get(0);
            onLoad = body.getOnLoadAttribute();
        } else {
            throw new IllegalStateException("Expected no more than one body tag but found [" + bodyTagCount + "] xml=" + this.asXml());
        }
        return onLoad;
    }

    public Object getOnLoadAttribute() {
        if (this.onLoad_ != null) {
            return this.onLoad_;
        }
        return this.getBodyOnLoadAttribute();
    }

    public void setOnLoadAttribute(Object newValue) {
        this.onLoad_ = newValue;
    }

    private void executeBodyOnLoadHandlerIfNeeded() {
        Object onLoad = this.getOnLoadAttribute();
        if (onLoad instanceof String) {
            String onLoadScript = (String)onLoad;
            if (onLoadScript.length() != 0) {
                if (onLoadScript.indexOf(40) == -1) {
                    onLoadScript = onLoadScript + "()";
                }
                this.executeJavaScriptIfPossible(onLoadScript, "body.onLoad", false, null);
            }
        } else {
            ScriptEngine engine = this.getWebClient().getScriptEngine();
            engine.callFunction(this, onLoad, null, new Object[0], null);
        }
    }

    private void initializeFramesIfNeeded() {
        this.getHtmlElementsByTagNames(Arrays.asList("frame", "iframe"));
    }

    public List getFrames() {
        return this.getHtmlElementsByTagNames(Arrays.asList("frame", "iframe"));
    }

    public HtmlElement pressAccessKey(char accessKey) throws IOException {
        HtmlElement element = this.getHtmlElementByAccessKey(accessKey);
        WebClient webClient = this.getWebClient();
        if (element != null) {
            webClient.moveFocusToElement(element);
            Page newPage = element instanceof HtmlButton ? ((HtmlButton)element).click() : (element instanceof HtmlInput ? ((HtmlInput)element).click() : this);
            if (newPage != this && webClient.getElementWithFocus() == element) {
                webClient.moveFocusToElement(null);
            }
        }
        return webClient.getElementWithFocus();
    }

    public HtmlElement tabToNextElement() {
        int index;
        List elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.getWebClient().moveFocusToElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getWebClient().getElementWithFocus();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? (HtmlElement)elements.get(0) : ((index = elements.indexOf(elementWithFocus)) == -1 ? (HtmlElement)elements.get(0) : (index == elements.size() - 1 ? (HtmlElement)elements.get(0) : (HtmlElement)elements.get(index + 1)));
        this.getWebClient().moveFocusToElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public HtmlElement tabToPreviousElement() {
        int index;
        List elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.getWebClient().moveFocusToElement(null);
            return null;
        }
        HtmlElement elementWithFocus = this.getWebClient().getElementWithFocus();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? (HtmlElement)elements.get(elements.size() - 1) : ((index = elements.indexOf(elementWithFocus)) == -1 ? (HtmlElement)elements.get(elements.size() - 1) : (index == 0 ? (HtmlElement)elements.get(elements.size() - 1) : (HtmlElement)elements.get(index - 1)));
        this.getWebClient().moveFocusToElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public void setScriptFilter(ScriptFilter scriptFilter) {
        this.scriptFilter_ = scriptFilter;
    }

    public ScriptFilter getScriptFilter() {
        return this.scriptFilter_;
    }

    class MyParser
    extends DOMParser {
        MyParser() {
        }

        public HTMLConfiguration getConfiguration() {
            return (HTMLConfiguration)((XMLParser)this).fConfiguration;
        }

        public Document getDocument() {
            return ((AbstractDOMParser)this).fDocument;
        }
    }
}

