/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import org.w3c.dom.Element;

public abstract class HtmlTableCell
extends HtmlElement {
    private final int rowIndex_;
    private final int columnIndex_;

    HtmlTableCell(HtmlPage page, Element element, int row, int column) {
        super(page, element);
        this.rowIndex_ = row;
        this.columnIndex_ = column;
    }

    public int getColumnIndex() {
        return this.columnIndex_;
    }

    public int getColumnSpan() {
        String spanString = this.getAttributeValue("colspan");
        if (spanString == null || spanString.length() == 0) {
            return 1;
        }
        return Integer.parseInt(spanString);
    }

    public int getRowIndex() {
        return this.rowIndex_;
    }

    public int getRowSpan() {
        String spanString = this.getAttributeValue("rowspan");
        if (spanString == null || spanString.length() == 0) {
            return 1;
        }
        return Integer.parseInt(spanString);
    }

    public boolean matchesPosition(int row, int column) {
        int rowMin = this.getRowIndex();
        int rowMax = rowMin + this.getRowSpan() - 1;
        int columnMin = this.getColumnIndex();
        int columnMax = columnMin + this.getColumnSpan() - 1;
        return row >= rowMin && row <= rowMax && column >= columnMin && column <= columnMax;
    }
}

