/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import org.apache.html.dom.HTMLTextAreaElementImpl;
import org.w3c.dom.Element;

public class HtmlTextArea
extends HtmlElement
implements SubmittableElement {
    private String value_ = this.getText();

    HtmlTextArea(HtmlPage page, Element element) {
        super(page, element);
    }

    public final String getValue() {
        return this.getText();
    }

    public final String getText() {
        return this.asText();
    }

    public final void setValue(String newValue) {
        if (newValue == null) {
            this.reset();
        } else {
            this.setText(newValue);
        }
    }

    public final void setText(String newValue) {
        Assert.notNull("newValue", newValue);
        HTMLTextAreaElementImpl textElement = (HTMLTextAreaElementImpl)this.getElement();
        textElement.setTextContent(newValue);
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), this.getValue())};
    }

    public void reset() {
        this.setText(this.value_);
    }

    public final String getIdAttribute() {
        return this.getAttributeValue("id");
    }

    public final String getClassAttribute() {
        return this.getAttributeValue("class");
    }

    public final String getStyleAttribute() {
        return this.getAttributeValue("style");
    }

    public final String getTitleAttribute() {
        return this.getAttributeValue("title");
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getRowsAttribute() {
        return this.getAttributeValue("rows");
    }

    public final String getColumnsAttribute() {
        return this.getAttributeValue("cols");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeValue("readonly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeValue("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }
}

