/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlElementCreator;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import java.util.Iterator;
import org.w3c.dom.Element;

class TableElementCreator
extends HtmlElementCreator {
    TableElementCreator() {
    }

    HtmlElement create(HtmlPage page, Element xmlElement) {
        String tagName = page.getTagName(xmlElement);
        if (tagName.equals("tr")) {
            return this.createTableRow(page, xmlElement);
        }
        if (tagName.equals("td") || tagName.equals("th")) {
            return this.createTableCell(page, xmlElement);
        }
        throw new IllegalStateException("Unexpected element " + xmlElement);
    }

    private HtmlElement createTableRow(HtmlPage page, Element xmlElement) {
        Iterator iterator = this.getTable(page, xmlElement).getRows().iterator();
        while (iterator.hasNext()) {
            HtmlTableRow row = (HtmlTableRow)iterator.next();
            if (row.getElement() != xmlElement) continue;
            return row;
        }
        throw new IllegalStateException("specified row could not be found in table");
    }

    private HtmlElement createTableCell(HtmlPage page, Element xmlElement) {
        Iterator rowIterator = this.getTable(page, xmlElement).getRows().iterator();
        while (rowIterator.hasNext()) {
            HtmlTableRow row = (HtmlTableRow)rowIterator.next();
            Iterator cellIterator = row.getCells().iterator();
            while (cellIterator.hasNext()) {
                HtmlTableCell cell = (HtmlTableCell)cellIterator.next();
                if (cell.getElement() != xmlElement) continue;
                return cell;
            }
        }
        throw new IllegalStateException("specified cell could not be found in table");
    }

    private HtmlTable getTable(HtmlPage page, Element startingElement) {
        Element element = startingElement;
        while (!page.getTagName(element).equals("table")) {
            element = (Element)element.getParentNode();
        }
        return (HtmlTable)page.getHtmlElement(element);
    }
}

