/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.StrictErrorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public final class JavaScriptConfiguration {
    private static Document XmlDocument_;
    private static final Object INITIALIZATION_LOCK;
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int NOT_FOUND = 3;
    private static Map ConfigurationMap_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaScriptConfiguration(BrowserVersion browserVersion) {
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            if (XmlDocument_ == null) {
                XmlDocument_ = this.loadConfiguration();
            }
        }
        if (XmlDocument_ == null) {
            throw new IllegalStateException("Configuration was not initialized - see log for details");
        }
    }

    private Document loadConfiguration() {
        try {
            InputStream inputStream = this.getConfigurationFileAsStream();
            if (inputStream == null) {
                this.getLog().error((Object)"Unable to load JavaScriptConfiguration.xml");
                return null;
            }
            InputSource inputSource = new InputSource(inputStream);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new StrictErrorHandler());
            return documentBuilder.parse(inputSource);
        }
        catch (SAXParseException parseException) {
            this.getLog().error((Object)("line=[" + parseException.getLineNumber() + "] columnNumber=[" + parseException.getColumnNumber() + "] systemId=[" + parseException.getSystemId() + "] publicId=[" + parseException.getPublicId() + "]"), (Throwable)parseException);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Error when loading JavascriptConfiguration.xml", (Throwable)e);
        }
        return null;
    }

    public static JavaScriptConfiguration getInstance(BrowserVersion browserVersion) {
        JavaScriptConfiguration configuration = (JavaScriptConfiguration)ConfigurationMap_.get(browserVersion);
        if (configuration == null) {
            configuration = new JavaScriptConfiguration(browserVersion);
            ConfigurationMap_.put(browserVersion, configuration);
        }
        return configuration;
    }

    private Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private int getState(Class hostClass, String type, String typeName, String booleanAttributeName) {
        Assert.notNull("hostClass", hostClass);
        Assert.notNull("typeName", typeName);
        Element classElement = this.getClassElement(this.getClassName(hostClass));
        while (classElement != null) {
            Element functionElement = this.getElementByTypeAndName(classElement, type, typeName);
            if (functionElement != null) {
                if (booleanAttributeName == null) {
                    return this.getEnabledState(functionElement);
                }
                if (this.getBooleanAttribute(functionElement, booleanAttributeName)) {
                    return this.getEnabledState(functionElement);
                }
                return 3;
            }
            String superClassName = classElement.getAttribute("extends");
            classElement = null;
            if (superClassName == null || superClassName.length() == 0) continue;
            classElement = this.getClassElement(superClassName);
        }
        return 3;
    }

    public int getReadablePropertyNameState(Class hostClass, String name) {
        return this.getState(hostClass, "property", name, "readable");
    }

    public int getWritablePropertyNameState(Class hostClass, String name) {
        return this.getState(hostClass, "property", name, "writable");
    }

    public int getFunctionNameState(Class hostClass, String name) {
        return this.getState(hostClass, "function", name, null);
    }

    private boolean getBooleanAttribute(Element classElement, String attributeName) {
        Assert.notNull("classElement", classElement);
        Assert.notNull("attributeName", attributeName);
        String value = classElement.getAttribute(attributeName);
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new IllegalStateException("Unexpected value for attribute [" + attributeName + "] on element [" + classElement + "] value=[" + value + "]");
    }

    private InputStream getConfigurationFileAsStream() {
        String fileName = "/com/gargoylesoftware/htmlunit/javascript/JavaScriptConfiguration.xml";
        return this.getResourceAsStream("/com/gargoylesoftware/htmlunit/javascript/JavaScriptConfiguration.xml");
    }

    private InputStream getResourceAsStream(String name) {
        InputStream inputStream;
        block5: {
            String localizedName;
            Assert.notNull("name", name);
            inputStream = this.getClass().getResourceAsStream(name);
            if (inputStream == null) {
                try {
                    localizedName = name.replace('/', File.separatorChar);
                    inputStream = new FileInputStream(localizedName);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (inputStream != null) break block5;
            try {
                localizedName = ("./src/java" + name).replace('/', File.separatorChar);
                inputStream = new FileInputStream(localizedName);
            }
            catch (IOException e) {}
        }
        return inputStream;
    }

    private String getClassName(Class hostClass) {
        Assert.notNull("hostClass", hostClass);
        String className = hostClass.getName();
        int index = className.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException("hostClass does not contain a dot [" + className + "]");
        }
        return className.substring(index + 1);
    }

    private Element getClassElement(String className) {
        Node node = XmlDocument_.getDocumentElement().getFirstChild();
        while (node != null) {
            Element element;
            if (node instanceof Element && (element = (Element)node).getTagName().equals("class") && className.equals(element.getAttribute("name"))) {
                return element;
            }
            node = node.getNextSibling();
        }
        this.getLog().warn((Object)("Unexpected class [" + className + "]"));
        return null;
    }

    private int getEnabledState(Element element) {
        Assert.notNull("element", element);
        return 1;
    }

    private Element getElementByTypeAndName(Element root, String type, String name) {
        Assert.notNull("type", type);
        Assert.notNull("name", name);
        Node node = root.getFirstChild();
        while (node != null) {
            Element element;
            if (node instanceof Element && (element = (Element)node).getTagName().equals(type) && name.equals(element.getAttribute("name"))) {
                return element;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    static {
        INITIALIZATION_LOCK = new Object();
        ConfigurationMap_ = new HashMap(11);
    }
}

