/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.DocumentAllArray;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Form;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Image;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public final class Document
extends HTMLElement {
    private DocumentAllArray allArray_;

    public final void jsConstructor() {
    }

    public void initialize() {
        if (this.allArray_ == null) {
            this.allArray_ = (DocumentAllArray)this.makeJavaScriptObject("DocumentAllArray");
            this.allArray_.initialize((HtmlPage)this.getHtmlElementOrDie());
        }
    }

    public HtmlPage getHtmlPage() {
        return (HtmlPage)this.getHtmlElementOrDie();
    }

    public NativeArray jsGet_forms() {
        ArrayList<Form> jsForms = new ArrayList<Form>();
        List formElements = this.getHtmlPage().getHtmlElementsByTagNames(Collections.singletonList("form"));
        Iterator iterator = formElements.iterator();
        while (iterator.hasNext()) {
            HtmlForm htmlForm = (HtmlForm)iterator.next();
            String formName = htmlForm.getAttributeValue("name");
            if (formName.length() == 0) continue;
            Form jsForm = (Form)((Object)htmlForm.getScriptObject());
            if (jsForm == null) {
                jsForm = (Form)this.makeJavaScriptObject("Form");
                jsForm.setHtmlElement(htmlForm);
                jsForm.initialize();
            }
            jsForms.add(jsForm);
        }
        boolean attributes = true;
        Form[] array = new Form[jsForms.size()];
        jsForms.toArray(array);
        NativeArray allForms = new NativeArray((Object[])array);
        int i = 0;
        while (i < array.length) {
            String name = array[i].getHtmlElementOrDie().getAttributeValue("name");
            allForms.defineProperty(name, (Object)array[i], 1);
            ++i;
        }
        return allForms;
    }

    public static Object jsFunction_write(Context context, Scriptable scriptable, Object[] args, Function function) {
        String content = SimpleScriptable.getStringArg(0, args, "");
        HtmlPage page = (HtmlPage)((Document)scriptable).getHtmlElementOrDie();
        page.getScriptFilter().write(content);
        return null;
    }

    public static Object jsFunction_writeln(Context context, Scriptable scriptable, Object[] args, Function function) {
        String content = SimpleScriptable.getStringArg(0, args, "");
        return Document.jsFunction_write(context, scriptable, new Object[]{content + "\n"}, function);
    }

    private HttpState getHttpState() {
        HtmlPage htmlPage = this.getHtmlPage();
        WebConnection connection = htmlPage.getWebClient().getWebConnection();
        URL url = htmlPage.getWebResponse().getUrl();
        return connection.getStateForUrl(url);
    }

    public String jsGet_cookie() {
        HttpState state = this.getHttpState();
        Cookie[] cookies = state.getCookies();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < cookies.length) {
            if (i != 0) {
                buffer.append(";");
            }
            buffer.append(cookies[i].getName());
            buffer.append("=");
            buffer.append(cookies[i].getValue());
            ++i;
        }
        return buffer.toString();
    }

    public Location jsGet_location() {
        WebWindow webWindow = ((HtmlPage)this.getHtmlElementOrDie()).getEnclosingWindow();
        return ((Window)((Object)webWindow.getScriptObject())).jsGet_location();
    }

    public NativeArray jsGet_images() {
        this.getLog().debug((Object)"Not implemented yet: document.images");
        return new NativeArray((Object[])new Image[0]);
    }

    public String jsGet_referrer() {
        String referrer = this.getHtmlPage().getWebResponse().getResponseHeaderValue("referrer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    public String jsGet_URL() {
        return this.getHtmlPage().getWebResponse().getUrl().toExternalForm();
    }

    public DocumentAllArray jsGet_all() {
        if (this.allArray_ == null) {
            this.initialize();
        }
        return this.allArray_;
    }

    public void jsFunction_close() {
        this.getLog().debug((Object)"Not implemented yet: document.close()");
    }

    public Object jsFunction_createElement(String tagName) {
        Object result;
        block3: {
            result = Scriptable.NOT_FOUND;
            try {
                HtmlElement htmlElement = this.getHtmlElementOrDie().getPage().createElement(tagName);
                SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
                if (jsElement == Scriptable.NOT_FOUND) {
                    this.getLog().debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a javascript object for the html element " + htmlElement.getClass().getName()));
                    break block3;
                }
                result = jsElement;
            }
            catch (ElementNotFoundException e) {}
        }
        return result;
    }

    public Object jsFunction_getElementById(String id) {
        Object result;
        block3: {
            result = Scriptable.NOT_FOUND;
            try {
                HtmlElement htmlElement = this.getHtmlElementOrDie().getPage().getHtmlElementById(id);
                SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
                if (jsElement == Scriptable.NOT_FOUND) {
                    this.getLog().debug((Object)("getElementById(" + id + ") cannot return a result as there isn't a javascript object for the html element " + htmlElement.getClass().getName()));
                    break block3;
                }
                result = jsElement;
            }
            catch (ElementNotFoundException e) {}
        }
        return result;
    }

    public Object jsFunction_getElementsByTagName(String tagName) {
        HtmlPage page = this.getHtmlElementOrDie().getPage();
        List list = page.getHtmlElementsByTagNames(Collections.singletonList(tagName.toLowerCase()));
        ListIterator<SimpleScriptable> iterator = list.listIterator();
        while (iterator.hasNext()) {
            HtmlElement htmlElement = (HtmlElement)iterator.next();
            iterator.set(this.getScriptableFor(htmlElement));
        }
        return new NativeArray(list.toArray());
    }

    public Object get(String name, Scriptable start) {
        HtmlPage htmlPage = (HtmlPage)this.getHtmlElementOrNull();
        if (htmlPage == null) {
            return super.get(name, start);
        }
        try {
            HtmlForm htmlForm = htmlPage.getFormByName(name);
            Form jsForm = (Form)((Object)htmlForm.getScriptObject());
            if (jsForm == null) {
                jsForm = (Form)this.makeJavaScriptObject("Form");
                jsForm.setHtmlElement(htmlForm);
                jsForm.initialize();
                return jsForm;
            }
            return jsForm;
        }
        catch (ElementNotFoundException e) {
            return super.get(name, start);
        }
    }
}

