/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.mozilla.javascript.Scriptable;

public class Style
extends SimpleScriptable {
    private HTMLElement jsElement_;

    public void initialize(HTMLElement htmlElement) {
        Assert.notNull("htmlElement", (Object)htmlElement);
        this.jsElement_ = htmlElement;
    }

    public Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (this.jsElement_ == null || result != Scriptable.NOT_FOUND) {
            return result;
        }
        Object value = this.getStyleMap().get(name);
        if (value == null) {
            return Scriptable.NOT_FOUND;
        }
        return value;
    }

    public void put(String name, Scriptable start, Object newValue) {
        if (this.jsElement_ == null) {
            super.put(name, start, newValue);
            return;
        }
        Map styleMap = this.getStyleMap();
        styleMap.put(name, newValue);
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = styleMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(entry.getKey());
            buffer.append(": ");
            buffer.append(entry.getValue());
            buffer.append("; ");
        }
        this.jsElement_.getHtmlElementOrDie().getElement().setAttribute("style", buffer.toString());
    }

    private Map getStyleMap() {
        TreeMap<String, String> styleMap = new TreeMap<String, String>();
        String styleAttribute = this.jsElement_.getHtmlElementOrDie().getAttributeValue("style");
        StringTokenizer tokenizer = new StringTokenizer(styleAttribute, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(":");
            if (index == -1) continue;
            String key = token.substring(0, index).trim();
            String value = token.substring(index + 1).trim();
            styleMap.put(key, value);
        }
        return styleMap;
    }
}

