/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public final class Window
extends SimpleScriptable {
    private Document document_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private Screen screen_;
    private History history_;
    private Location location_;

    public final void jsConstructor() {
    }

    public void jsFunction_alert(String message) {
        AlertHandler handler = this.getJavaScriptEngine().getWebClient().getAlertHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.alert(\"" + message + "\") no alert handler installed"));
        } else {
            handler.handleAlert(this.document_.getHtmlPage(), message);
        }
    }

    public boolean jsFunction_confirm(String message) {
        ConfirmHandler handler = this.getJavaScriptEngine().getWebClient().getConfirmHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.confirm(\"" + message + "\") no confirm handler installed"));
            return false;
        }
        return handler.handleConfirm(this.document_.getHtmlPage(), message);
    }

    public String jsFunction_prompt(String message) {
        PromptHandler handler = this.getJavaScriptEngine().getWebClient().getPromptHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.prompt(\"" + message + "\") no prompt handler installed"));
            return null;
        }
        return handler.handlePrompt(this.document_.getHtmlPage(), message);
    }

    public Document jsGet_document() {
        return this.document_;
    }

    public static Object jsFunction_open(Context context, Scriptable scriptable, Object[] args, Function function) {
        String url = SimpleScriptable.getStringArg(0, args, null);
        String windowName = SimpleScriptable.getStringArg(1, args, "");
        String features = SimpleScriptable.getStringArg(2, args, null);
        boolean replaceCurrentEntryInBrowsingHistory = SimpleScriptable.getBooleanArg(3, args, false);
        Window thisWindow = (Window)scriptable;
        if (features != null || replaceCurrentEntryInBrowsingHistory) {
            thisWindow.getLog().debug((Object)("Window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + url + "] windowName=[" + windowName + "] features=[" + features + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]"));
        }
        URL newUrl = thisWindow.makeUrlForOpenWindow(url);
        WebWindow newWebWindow = thisWindow.webWindow_.getWebClient().openWindow(newUrl, windowName, thisWindow.webWindow_);
        return (Window)((Object)newWebWindow.getScriptObject());
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.length() == 0) {
            return null;
        }
        try {
            Page page = this.webWindow_.getEnclosedPage();
            if (page != null && page instanceof HtmlPage) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)("Unable to create url for openWindow: relativeUrl=[" + urlString + "]"), (Throwable)e);
            return null;
        }
    }

    public static Object jsFunction_setTimeout(Context context, final Scriptable scriptable, Object[] args, Function function) {
        final String script = SimpleScriptable.getStringArg(0, args, null);
        final int timeout = SimpleScriptable.getIntArg(1, args, 0);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Window window = (Window)scriptable;
                try {
                    try {
                        Thread.sleep(timeout);
                        Context.enter();
                        HtmlPage htmlPage = window.document_.getHtmlPage();
                        htmlPage.executeJavaScriptIfPossible(script, "Window.setTimeout()", true, htmlPage);
                    }
                    catch (Exception e) {
                        window.getLog().error((Object)"Caught exception in Window.setTimeout()", (Throwable)e);
                        Object var4_5 = null;
                        Context.exit();
                        return;
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    Context.exit();
                    throw throwable;
                }
                Context.exit();
            }
        };
        new Thread(runnable).start();
        return null;
    }

    public Navigator jsGet_navigator() {
        return this.navigator_;
    }

    public Window jsGet_window() {
        return this;
    }

    public Window jsGet_self() {
        return this;
    }

    public Location jsGet_location() {
        return this.location_;
    }

    public void jsSet_location(String newLocation) {
        try {
            HtmlPage page = (HtmlPage)this.webWindow_.getEnclosedPage();
            URL url = page.getFullyQualifiedUrl(newLocation);
            this.webWindow_.getWebClient().getPage(this.webWindow_, url, SubmitMethod.GET, Collections.EMPTY_LIST);
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)("jsSet_location(\"" + newLocation + "\") Got MalformedURLException"), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((Object)("jsSet_location(\"" + newLocation + "\") Got IOException"), (Throwable)e);
        }
    }

    public Screen jsGet_screen() {
        return this.screen_;
    }

    public History jsGet_history() {
        return this.history_;
    }

    public void initialize(final HtmlPage htmlPage) throws Exception {
        this.webWindow_ = htmlPage.getEnclosingWindow();
        this.webWindow_.setScriptObject((Object)this);
        if (this.webWindow_ instanceof HtmlElement) {
            this.setHtmlElement((HtmlElement)((Object)this.webWindow_));
        }
        this.document_ = (Document)this.makeJavaScriptObject("Document");
        this.document_.setHtmlElement(htmlPage);
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("element")) {
                    Window.this.document_.initialize();
                    htmlPage.removePropertyChangeListener(this);
                }
            }
        };
        htmlPage.addPropertyChangeListener(listener);
        this.navigator_ = (Navigator)this.makeJavaScriptObject("Navigator");
        this.screen_ = (Screen)this.makeJavaScriptObject("Screen");
        this.history_ = (History)this.makeJavaScriptObject("History");
        this.location_ = (Location)this.makeJavaScriptObject("Location");
        this.location_.initialize(this);
    }

    public SimpleScriptable jsGet_top() {
        WebWindow window = this.webWindow_;
        while (window != null) {
            if (window instanceof TopLevelWindow) {
                return (SimpleScriptable)((Object)window.getScriptObject());
            }
            window = ((HtmlElement)((Object)window)).getPage().getEnclosingWindow();
        }
        throw new IllegalStateException("Couldn't find a TopLevelWindow!");
    }

    public SimpleScriptable jsGet_parent() {
        SimpleScriptable parent;
        if (this.webWindow_ instanceof TopLevelWindow) {
            parent = this;
        } else {
            WebWindow parentWebWindow = ((HtmlElement)((Object)this.webWindow_)).getPage().getEnclosingWindow();
            parent = (SimpleScriptable)((Object)parentWebWindow.getScriptObject());
        }
        return parent;
    }

    public Object jsGet_opener() {
        WebWindow opener;
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            return (Window)((Object)opener.getScriptObject());
        }
        return Scriptable.NOT_FOUND;
    }

    public SimpleScriptable[] jsGet_frames() {
        Page page = this.webWindow_.getEnclosedPage();
        if (page == null || !(page instanceof HtmlPage)) {
            return new SimpleScriptable[0];
        }
        HtmlPage htmlPage = (HtmlPage)page;
        List frames = htmlPage.getFrames();
        int frameCount = frames.size();
        SimpleScriptable[] jsFrames = new SimpleScriptable[frameCount];
        int i = 0;
        while (i < frameCount) {
            jsFrames[i] = (SimpleScriptable)((Object)((WebWindow)frames.get(i)).getScriptObject());
            ++i;
        }
        return jsFrames;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void jsFunction_focus() {
        this.getLog().debug((Object)"Window.focus() not implemented");
    }

    public void jsFunction_blur() {
        this.getLog().debug((Object)"Window.blur() not implemented");
    }

    public void jsFunction_close() {
        this.getLog().debug((Object)"Window.close() not implemented");
    }

    public String jsGet_src() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof HtmlInlineFrame) {
            return ((HtmlInlineFrame)webWindow).getSrcAttribute();
        }
        return "";
    }

    public void jsSet_src(String newValue) {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof HtmlInlineFrame) {
            ((HtmlInlineFrame)webWindow).setSrcAttribute(newValue);
        }
    }

    public void jsSet_onload(Object newValue) {
        if (this.webWindow_.getEnclosedPage() instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)this.webWindow_.getEnclosedPage();
            if (newValue instanceof Function) {
                page.setOnLoadAttribute(newValue);
            } else {
                this.getLog().error((Object)("Invalid value set to window.onload.  Value class: " + newValue.getClass()));
            }
        }
    }

    public Object jsGet_onload() {
        if (this.webWindow_.getEnclosedPage() instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)this.webWindow_.getEnclosedPage();
            return page.getOnLoadAttribute();
        }
        return "";
    }

    public String jsGet_name() {
        return this.webWindow_.getName();
    }
}

