/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std;

import com.sun.jsfcl.std.RaveStringEditor;
import com.sun.jsfcl.util.ComponentBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class RaveStringCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    protected static final ComponentBundle bundle = ComponentBundle.getBundle(RaveStringCustomEditor.class);
    boolean oneline = false;
    String instructions = null;
    private JScrollPane textAreaScroll;
    private JTextComponent textArea;
    protected boolean ignoreCrs;
    protected RaveStringEditor propertyEditor;

    RaveStringCustomEditor(String value, boolean editable, boolean oneline, String instructions, boolean ignoreCrs, RaveStringEditor propertyEditor) {
        this.oneline = oneline;
        this.instructions = instructions;
        this.ignoreCrs = ignoreCrs;
        this.propertyEditor = propertyEditor;
        this.init(value, editable);
    }

    public RaveStringCustomEditor(String s, boolean editable, RaveStringEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        this.init(s, editable);
    }

    private void init(String s, boolean editable) {
        this.setLayout(new BorderLayout());
        if (this.oneline) {
            this.textArea = new JTextField();
            this.add((Component)this.textArea, "Center");
        } else {
            this.textAreaScroll = new JScrollPane();
            this.textArea = new JTextArea();
            this.textAreaScroll.setViewportView(this.textArea);
            this.add((Component)this.textAreaScroll, "Center");
            if (this.ignoreCrs) {
                this.textArea.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent event) {
                        if (event.getKeyCode() == 10) {
                            event.consume();
                        }
                    }

                    public void keyPressed(KeyEvent event) {
                        if (event.getKeyCode() == 10) {
                            event.consume();
                        }
                    }

                    public void keyTyped(KeyEvent event) {
                        if (event.getKeyCode() == 10) {
                            event.consume();
                        }
                    }
                });
            }
        }
        this.textArea.setEditable(editable);
        this.textArea.setText(s);
        if (this.textArea instanceof JTextArea) {
            ((JTextArea)this.textArea).setWrapStyleWord(true);
            ((JTextArea)this.textArea).setLineWrap(true);
            this.setPreferredSize(new Dimension(500, 300));
            if (!editable) {
                JTextField hack = new JTextField();
                hack.setEditable(false);
                this.textArea.setBackground(hack.getBackground());
                this.textArea.setForeground(hack.getForeground());
            }
        } else {
            this.textArea.setMinimumSize(new Dimension(100, 20));
        }
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.textArea.getAccessibleContext().setAccessibleName(bundle.getMessage("ACS_TextArea"));
        if (this.instructions == null) {
            this.textArea.getAccessibleContext().setAccessibleDescription(bundle.getMessage("ACSD_TextArea"));
        } else {
            this.textArea.getAccessibleContext().setAccessibleDescription(this.instructions);
        }
        this.getAccessibleContext().setAccessibleDescription("ACSD_CustomStringEditor");
        int prefHeight = this.textArea.getPreferredSize().height + 8;
        if (this.instructions != null) {
            final JTextArea jta = new JTextArea(this.instructions);
            jta.setEditable(false);
            Color c = UIManager.getColor("control");
            if (c != null) {
                jta.setBackground(c);
            } else {
                jta.setBackground(this.getBackground());
            }
            jta.setLineWrap(true);
            jta.setWrapStyleWord(true);
            jta.setFont(this.getFont());
            this.add(jta, "North", 0);
            jta.getAccessibleContext().setAccessibleName(bundle.getMessage("ACS_Instructions"));
            jta.getAccessibleContext().setAccessibleDescription(bundle.getMessage("ACSD_Instructions"));
            prefHeight += jta.getPreferredSize().height;
            jta.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    jta.setSelectionStart(0);
                    jta.setSelectionEnd(jta.getText().length());
                }

                public void focusLost(FocusEvent e) {
                    jta.setSelectionStart(0);
                    jta.setSelectionEnd(0);
                }
            });
        }
        if (this.textArea instanceof JTextField) {
            this.setPreferredSize(new Dimension(300, prefHeight));
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.isEnabled() && this.isFocusable()) {
            this.textArea.requestFocus();
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.propertyEditor.getCustomEditorValue(this.textArea.getText());
    }
}

